# -*- coding: utf-8 -*-

import os
import logging

from sandbox import sdk2
from sandbox.projects.resource_types import ADDRS_BUSINESS_SHARDMAP
from sandbox.projects.geosearch.ReleaseAddrsShardmap import ReleaseAddrsShardmap


class MakeAddrsShardmap(ReleaseAddrsShardmap):
    """
        Fix given ADDRS_BUSINESS_SHARDMAP resource for deploy to service
    """

    class Parameters(sdk2.task.Parameters):
        kill_timeout = 24000
        service = sdk2.parameters.String('Release to', required=True)
        shardmap = sdk2.parameters.Resource('Shardmap to release',
                                            resource_type=ADDRS_BUSINESS_SHARDMAP,
                                            required=True)

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        old_shardmap_path = self.find_shardmap()
        srv_virtual_shard_names = self._get_shardnames()
        with open(old_shardmap_path, 'r') as f:
            self.old_shardmap = f.readlines()
        logging.info('Old shardmap = %s' % self.old_shardmap)
        self.basesearch_tasks = self.get_basesearch_task_ids()
        self.shard_dirs = []
        new_shard_map = []
        for line in self.old_shardmap:
            for srv_virt_shard_name in srv_virtual_shard_names:
                lst = line.split()
                old_virtual_shard_name = lst[0]
                real_shard_name = lst[1]
                tier_name = lst[2]
                logging.info('srv_virt_shard_name = %s' % srv_virt_shard_name)
                logging.info('old_virtual_shard_name = %s' % old_virtual_shard_name)
                logging.info('real_shard_name = %s' % real_shard_name)
                logging.info('tier_name = %s' % tier_name)
                tail = old_virtual_shard_name.split('-', 1)[-1]
                if tail in srv_virt_shard_name:
                    new_line = '%s\t%s\t%s\n' % (srv_virt_shard_name,
                                                 real_shard_name,
                                                 tier_name)
                    new_shard_map.append(new_line)
        logging.info('new_shard_map = %s' % new_shard_map)
        self.new_shardmap_path = 'addrs_business_shard.map'
        with open(self.new_shardmap_path, 'w') as f:
            f.writelines(new_shard_map)
            logging.info('Fixed shardmap written to %s'
                         % os.path.abspath('addrs_business_shard.map'))
        shardmap_resource = sdk2.Resource[ADDRS_BUSINESS_SHARDMAP]
        current_shardmap_resource = shardmap_resource(self,
                                                      'Addrs basesearch shardmap',
                                                      self.new_shardmap_path)
        shardmap_data = sdk2.ResourceData(current_shardmap_resource)
        shardmap_data.ready()
