# -*- coding: utf-8 -*-
import logging
import datetime
from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.projects import resource_types
from sandbox.projects.GetAddrsRequests import GetAddrsRequests


class MakeAddrsShootingPlan(sdk2.Task):
    '''Gather requests from production, make BASESEARCH_PLAN resource'''

    class Parameters(sdk2.task.Parameters):
        # service = sdk2.parameters.String('Collect requests for', required=True)
        with sdk2.parameters.String('Collect requests for',
                                    required=True) as service_choices:
            service_choices.values['Business'] = 'Business'
            service_choices.values['Wiki'] = 'Wiki'
            service_choices.values['Geocoder'] = 'Geocoder'
            service_choices.values['Geo'] = 'Middle'
        with sdk2.parameters.String('Collect requests from location',
                                    required=True) as location_choices:
            location_choices.values['VLA_ADDRS_NEW'] = 'VLA_ADDRS_NEW'
            location_choices.values['MAN_ADDRS_NEW'] = 'MAN_ADDRS_NEW'
            location_choices.values['SAS_ADDRS_NEW'] = 'SAS_ADDRS_NEW'
        time_interval = sdk2.parameters.String('Time interval in seconds',
                                               default_value='15')
        number_of_hosts = sdk2.parameters.String('Limit number of hosts (0 for all hosts)',
                                                 default_value='10')
        minimal_plan_size = sdk2.parameters.String('Minimal plan size (in bytes)',
                                                   default_value='1000000')

    def on_execute(self):
        GetAddrsRequestsTask = sdk2.Task[GetAddrsRequests.type]
        get_requests = GetAddrsRequestsTask(self,
                                            description='Get %s requests' % self.Parameters.service_choices,
                                            create_sub_task=False,
                                            location=self.Parameters.location_choices,
                                            service=self.Parameters.service_choices,
                                            time_interval=self.Parameters.time_interval,
                                            number_of_hosts=self.Parameters.number_of_hosts)
        get_requests.enqueue()
        logging.info(get_requests)
        raise sdk2.WaitTask([get_requests.id],
                            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                            # ctt.Status.Group.FINISH,
                            wait_all=False)
        logging.info(get_requests.__dict__)
        queries_resource = sdk2.Resource.find(resource_types.PLAIN_TEXT_QUERIES,
                                              task=get_requests).first()
        logging.info(queries_resource)
        GeneratePlanTask = sdk2.Task["GENERATE_PLAN_FROM_QUERIES"]
        date = datetime.datetime.now().strftime('%Y-%m-%d')
        generate_plan = GeneratePlanTask(self,
                                         create_sub_task=False,
                                         description='ppo_requests_%s' % date,
                                         queries_resource_id=queries_resource.id)
        generate_plan.enqueue()
        raise sdk2.WaitTask([generate_plan.id],
                            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                            # ctt.Status.Group.FINISH,
                            wait_all=False)
        # shooting_plan_resource = sdk2.Resource.find(resource_types.BASESEARCH_PLAN, task=generate_plan).first()
