import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.geosearch import resource_types as geo_types


class MergeFreshStatesIntoCompanies(sdk2.Task):
    """
        ALTAY-12822
    """
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        fresh_states_collector = sdk2.parameters.Resource(
            'Collector executable',
            resource_type=geo_types.FAST_EXPORT_COLLECT_CHANGES,
            required=True
        )
        cluster = sdk2.parameters.String('YT cluster')
        fresh_states_input = sdk2.parameters.String('fresh_states table path')

    def on_execute(self):
        executable = str(sdk2.ResourceData(self.Parameters.fresh_states_collector).path)

        yt_token = sdk2.Vault.data('ALTAY', 'altay_db_yt_token')

        os.environ['YT_TOKEN'] = yt_token

        cmd = [
            executable,
            'merge-fresh-states-into-companies'
        ]
        if self.Parameters.cluster:
            cmd.extend(['--cluster', self.Parameters.cluster])
        if self.Parameters.fresh_states_input:
            cmd.extend(['--fresh-states-input', self.Parameters.fresh_states_input])

        subprocess.check_call(cmd)
