import sandbox.sandboxsdk.task as sdk_task
from sandbox.projects import resource_types
from sandbox.projects.geosearch import resource_types as geo_resource_types
from sandbox.sandboxsdk.paths import copy_path
from sandbox.projects.common.apihelpers import get_last_released_resource


class PrepareAddrsBaseDataForTestenv(sdk_task.SandboxTask, object):
    '''Task for load testing addrs services'''

    type = 'PREPARE_ADDRS_BASE_DATA_FOR_TESTENV'

    def on_execute(self):
        advert_id = get_last_released_resource(resource_type=resource_types.MAPS_DATABASE_ADVERT)
        tmp_advert_path = self.sync_resource(advert_id)
        advert_path = './advert/%s' % tmp_advert_path.split('/')[-1]
        copy_path(tmp_advert_path, advert_path)
        self.create_resource(description='Addrs advert for TestEnv',
                             resource_path=advert_path,
                             resource_type=resource_types.MAPS_DATABASE_ADVERT,
                             attributes={'maps_database_advert_for_business_prod': True, 'ttl': 'inf'})
        fast_features_id = get_last_released_resource(resource_type=geo_resource_types.MAPS_DATABASE_FAST_FEATURES_SHARD)
        tmp_fast_features_path = self.sync_resource(fast_features_id)
        fast_features_path = './fast_features/%s' % tmp_fast_features_path.split('/')[-1]
        copy_path(tmp_fast_features_path, fast_features_path)
        self.create_resource(description='Addrs fast_features for TestEnv',
                             resource_path=fast_features_path,
                             resource_type=geo_resource_types.MAPS_DATABASE_FAST_FEATURES_SHARDED,
                             attributes={'maps_fast_features_for_business_prod': True, 'ttl': 'inf'})
