# -*- coding: utf-8 -*-

import os
import logging
import urllib2
import json

from sandbox.projects import resource_types
from sandbox import sdk2
from sandbox.projects.geosearch.tools.nanny import Nanny
from sandbox.projects.release_machine import rm_notify


@rm_notify.notify2()
class ReleaseAddrsShardmap(sdk2.Task):
    """
        Fix and release ADDRS_BUSINESS_SHARDMAP
    """

    class Parameters(sdk2.task.Parameters):
        kill_timeout = 24000
        service = sdk2.parameters.String('Release to', required=True)
        shardmap = sdk2.parameters.Resource('Shardmap to release',
                                            resource_type=resource_types.ADDRS_BUSINESS_SHARDMAP,
                                            required=True)
        deploy_to_ssd = sdk2.parameters.Bool('Deploy to SSD',
                                             required=True,
                                             default_value=True)

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def get_basesearch_task_ids(self):
        task_ids = []
        for line in self.old_shardmap:
            real_name = line.split()[1]
            if real_name.endswith('fix'):
                logging.info('Real shardmane ends with fix')
                task = real_name.split('-')[-2]
                logging.info('ADDRS_BASESEARCH_SAAS id is %s' % task)
            else:
                logging.info('Real shardmane has no fix on the end')
                task = real_name.split('-')[-1]
                logging.info('ADDRS_BASESEARCH_SAAS id is %s' % task)
            task_ids.append(task)
        return task_ids

    def _get_gencfg_groups(self):
        token = sdk2.Vault.data('robot-geosearch', 'ADDRS')
        nanny = Nanny(token)
        instances = nanny.get_instances(self.Parameters.service)
        logging.info(instances)
        groups = instances.get('extended_gencfg_groups')
        logging.info(groups)
        return {group.get('name'): group.get('release') for group in groups.get('groups')}

    def _get_shardnames(self):
        shardnames = set()
        groups = self._get_gencfg_groups()
        for group, topology in groups.iteritems():
            url = ('http://api.gencfg.yandex-team.ru/'
                   '%s/searcherlookup/groups/%s/instances') % (topology, group)
            logging.info('get_shardnames url: %s' % url)
            request = urllib2.urlopen(url)
            response = request.read()
            data = json.loads(response)
            shards = set(host.get('shard_name') for host in data.get('instances'))
            shardnames.update(shards)
        logging.info('%s shardnames: %s' % (self.Parameters.service,
                                            shardnames))
        return list(shardnames)

    def _match_virtual_shardname(self, suffix):
        pass

    def _get_shard_conf(self, path):
        for root, sub_dir, file_names in os.walk(path):
            for file_name in file_names:
                if 'shard.conf' in file_name:
                    shard_conf = os.path.join(root, file_name)
                    logging.info('shard.conf file found in %s' % shard_conf)
                    return shard_conf

    def find_shardmap(self):
        old_shardmap_path = sdk2.ResourceData(self.Parameters.shardmap).path
        return str(old_shardmap_path)

    def on_execute(self):
        old_shardmap_path = self.find_shardmap()
        srv_virtual_shard_names = self._get_shardnames()
        with open(old_shardmap_path, 'r') as f:
            self.old_shardmap = f.readlines()
        logging.info('Old shardmap = %s' % self.old_shardmap)
        self.basesearch_tasks = self.get_basesearch_task_ids()
        self.shard_dirs = []
        # for basesearch_task_id in self.basesearch_tasks:
        #     basesearch_task = sdk2.Task[basesearch_task_id]
        #     shard_resource = sdk2.Resource.find(resource_types.ADDRS_BUSINESS_SHARD,
        #                                         task=basesearch_task).first()
        #     logging.info('Synced %s' % shard_resource)
        #     shard_path = str(sdk2.ResourceData(shard_resource).path)
        #     logging.info('Synced %s to %s' % (shard_resource, shard_path))
        new_shard_map = []
        for line in self.old_shardmap:
            for srv_virt_shard_name in srv_virtual_shard_names:
                lst = line.split()
                old_virtual_shard_name = lst[0]
                real_shard_name = lst[1]
                tier_name = lst[2]
                logging.info('srv_virt_shard_name = %s' % srv_virt_shard_name)
                logging.info('old_virtual_shard_name = %s' % old_virtual_shard_name)
                logging.info('real_shard_name = %s' % real_shard_name)
                logging.info('tier_name = %s' % tier_name)
                tail = old_virtual_shard_name.split('-', 1)[-1]
                if tail in srv_virt_shard_name:
                    new_line = '%s\t%s\t%s\n' % (srv_virt_shard_name, real_shard_name, tier_name)
                    new_shard_map.append(new_line)
        logging.info('new_shard_map = %s' % new_shard_map)
        self.new_shardmap_path = 'addrs_business_shard.map'
        with open(self.new_shardmap_path, 'w') as f:
            f.writelines(new_shard_map)
            logging.info('Fixed shardmap written to %s'
                         % os.path.abspath('addrs_business_shard.map'))
        shardmap_resource = sdk2.Resource[resource_types.ADDRS_BUSINESS_SHARDMAP]
        current_shardmap_resource = shardmap_resource(self,
                                                      'Addrs basesearch shardmap',
                                                      self.new_shardmap_path)
        shardmap_data = sdk2.ResourceData(current_shardmap_resource)
        shardmap_data.ready()
        token = sdk2.Vault.data('robot-geosearch', 'ADDRS')
        nanny = Nanny(token)
        nanny.replace_shardmap(self.Parameters.service,
                               self.author,
                               str(current_shardmap_resource.id),
                               resource_type=str(current_shardmap_resource.type),
                               task_id=str(self.id),
                               task_type=str(self.type),
                               ssd_deploy=self.Parameters.deploy_to_ssd)
        comment = ('Added #%s resource (%s)'
                   % (current_shardmap_resource, self.author))
        nanny.activate_service(dst_service=self.Parameters.service,
                               comment=comment)
