# -*- coding: utf-8 -*

from sandbox import sdk2
from sandbox.projects.common.geosearch.base_update import generate_base_update_task_sdk2
from sandbox.projects.geosearch.AddrsBaseDatabaseYtBuild import AddrsBaseDatabaseYtBuild
from sandbox.sandboxsdk import environments


UpdateTask = generate_base_update_task_sdk2(AddrsBaseDatabaseYtBuild,
                                            release_subject='Build addrs base database')


class UpdateAddrsBaseDatabaseYtBuild(UpdateTask):
    '''
        Update addrs base database
    '''
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

        environments = (environments.PipEnvironment('yandex-yt', use_wheel=True),)

        class Caches(sdk2.Requirements.Caches):
            pass

    def _setup_yt_client(self, yt_client):
        yt_client.config['token'] = sdk2.Vault.data('GEOMETA-SEARCH', 'yt-token')
        yt_client.config['proxy']['url'] = 'hahn.yt.yandex.net'
        return True
