import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.geosearch import resource_types as geo_types


class UpdateAddrsFreshStates(sdk2.Task):
    """
        Update "export" for freshness on YT (fresh_states table)
    """
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        logfeller_dir = sdk2.parameters.String("Logfeller dir of freshness logbroker queue")
        fresh_states_table = sdk2.parameters.String("Table to update")
        max_states_age = sdk2.parameters.Integer("Max age of orgs collected in table (in days)",
                                                 default=7)
        max_logfeller_tables_age = sdk2.parameters.Integer("Max age of logfeller tables to collect data from (minutes)",
                                                           default=60)

        fresh_states_collector = sdk2.parameters.Resource(
            'Collector executable',
            resource_type=geo_types.FAST_EXPORT_COLLECT_CHANGES,
            required=True
        )

    def on_execute(self):
        executable = str(sdk2.ResourceData(self.Parameters.fresh_states_collector).path)

        yt_token = sdk2.Vault.data('GEOMETA-SEARCH', 'yt-token')

        os.environ['MR_RUNTIME'] = 'YT'
        os.environ['YT_TOKEN'] = yt_token

        cmd = [
            executable,
            "--log-dir", self.Parameters.logfeller_dir,
            "--fresh-states-input", self.Parameters.fresh_states_table,
            "--states-age", str(self.Parameters.max_states_age),
            "--tables-age", str(self.Parameters.max_logfeller_tables_age),
        ]

        subprocess.check_call(cmd)
