# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.projects.geosearch.AddrsPackUrlTries import AddrsPackUrlTries


class UpdateAddrsUrlTries(sdk2.Task):
    """
        Pack url tries resources into one resurce and release it to nanny
    """
    class Parameters(sdk2.Task.Parameters):
        trie_names = sdk2.parameters.String("Trie names (comma separated)", required=True)

    def on_execute(self):
        if self.Context.subtasks:
            subtasks = list(self.find(id=self.Context.subtasks).limit(len(self.Context.subtasks)))
        else:
            subtasks = None
        if not subtasks:
            subtasks = []
            subtask = AddrsPackUrlTries(self, description="Update url tries and release", create_sub_task=False)
            subtask.Parameters.trie_names = self.Parameters.trie_names
            subtask.save()
            subtasks.append(subtask.enqueue())

            if subtasks:
                self.Context.subtasks = map(lambda _: _.id, subtasks)

            raise sdk2.WaitTask(subtasks,
                                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                                wait_all=True)
        else:
            self.server.release(task_id=self.Context.subtasks[0], type=ctt.ReleaseStatus.STABLE, subject="Release geosearch url tries")
