USE %CLUSTER%;

$FixEvent = Python::FixEvent("(Json?) -> String?", 
@@
def FixEvent(data):
    import json, re
    event = json.loads(data)
    if event["description"]:
        event['description'] = re.sub(r"<a href[^>^<]*>", "", re.sub(r"</?.?>", "", event["description"]))
    if event["type"]["code"] != "theatre":
        return json.dumps(event)
    if "participants" not in event:
        event["type"]["code"] = "concert"
        return json.dumps(event)
    has_actors = False
    has_director = False
    for participant in event["participants"]:
        if participant["role"] == "actor":
            has_actors = True
        if participant["role"] == "director":
            has_director = True
    if not (has_actors and has_director):
        event["type"]["code"] = "concert"
    return json.dumps(event)
@@);

$concat = ($event, $place, $schedule, $schedule_info, $rank) -> {
    RETURN "event_json=" || ToBytes(
        Yson::SerializeJson(
            Yson::From(
                AsStruct(
                    Yson::ParseJson($FixEvent(Yson::SerializeJson($event))) as event,
                    $place as place,
                    $schedule as schedule,
                    $schedule_info as schedule_info,
                    $rank as rank
                )
            )
        )
    )
};

INSERT INTO [%OUTPUT_TABLE%]
WITH TRUNCATE
SELECT
    Yson::ConvertToString(event.id) AS key,
    $concat(event, place, schedule, schedule_info, rank) AS value
FROM [%INPUT_TABLE%]
WHERE Yson::ConvertToString(event{"type"}{"code"}) != "cinema";
