use %CLUSTER%;

PRAGMA yt.InferSchema;

$only_rub_price_currency = Python::OnlyRubPriceCurrency("(Json?) -> Bool",
@@
def OnlyRubPriceCurrency(schedule):
    import json
    schedule = json.loads(schedule)
    currencies = set({})
    for session in schedule:
        for price in session["prices"]:
            currencies.add(price["currency_code"])
    if len(currencies) > 1:
        return False
    if len(currencies) == 0:
        return True
    return "rub" in currencies
@@);


$PrepareTextSnippet = Python::PrepareTextSnippet("(Json?, Json?, Json?, Json?) -> Json?", 
@@
def PrepareTextSnippet(event, place, schedule, schedule_info):
    import json, re
    from datetime import datetime, timedelta

    def CutDescription(description, max_length=270):
        if not description:
            return None
        description = event["description"].replace("\n", " ").replace("\t", " ").replace("\n", " ").replace('"', "'")

        if len(description) > max_length:
            words = description.split()
            word_pos = cur_len = 0
            while cur_len < max_length and word_pos < len(words):
                cur_len += len(words[word_pos])
                word_pos += 1
            if word_pos <= len(words):
                description = (" ".join(words[ : word_pos]) + "...").replace('"', "'")
        return unicode(description)

    def GetMinPricePhrase(schedule_info):
        initial_min_price = 1000000000
        if not schedule_info["sale_available"] or len(schedule_info["prices"]) == 0:
            return u""
        min_price = initial_min_price
        for price in schedule_info["prices"]:
            if price["currency_code"] == "rub":
                min_price = min(min_price, price["value"])
        if min_price < initial_min_price:
            return u"Билеты от " + str(min_price / 100)
        else:
            return u""

    def GetSchedulePhrase(schedule_info, schedule):
        monthes_ru = [u"января", u"февраля", u"марта", u"апреля", u"мая", u"июня", u"июля", u"августа", u"сентября", u"октября", u"ноября", u"декабря"]
        dates = sorted(schedule_info["dates"])
        result = u""
        if len(dates) > 6:
            from_time = datetime.strptime(dates[0], "%Y-%m-%d")
            to_time = datetime.strptime(dates[-1], "%Y-%m-%d")
            if to_time - from_time < timedelta(days=90):
                result = str(from_time.day) + u" " + monthes_ru[from_time.month - 1] + u" - " + str(to_time.day) + u" " + monthes_ru[to_time.month - 1]
                result += u"."
        elif len(dates) > 0:
            groupped_dates = []
            prev_month = None
            for date in dates:
                month = datetime.strptime(date, "%Y-%m-%d").month
                day = datetime.strptime(date, "%Y-%m-%d").day
                if month != prev_month:
                    if len(groupped_dates) == 3:
                        break
                    else:
                        groupped_dates.append({
                            "month" : month,
                            "days" : [str(day)]
                        })
                else:
                    if len(groupped_dates) > 0:
                        groupped_dates[-1]["days"].append(str(day))
                prev_month = month
            month_parts = []
            for i, month in enumerate(groupped_dates):
                month_parts.append(u", ".join(month["days"]) + u" " + monthes_ru[month["month"] - 1])
            result = u", ".join(month_parts)
            pos = result.rfind(",")
            if pos >= 0:
                result = result[:pos] + u" и" + result[pos+1 :]
            if len(dates) == 1 and schedule is not None and len(schedule) > 0 and schedule[0]["datetime"] is not None:
                result += u" " + schedule[0]["datetime"][11:16]
            result += u"."
        return result

    event = json.loads(event)
    place = json.loads(place)
    schedule = json.loads(schedule)
    schedule_info = json.loads(schedule_info)
    event_type = event["type"]["code"]
    if event_type == "theatre":
        title = event["title"] + u" — билеты в театр — " + place["title"] + u" — " + place["city"]["name"]
    elif event_type == "concert":
        title = event["title"] + u" — билеты на концерт — " + place["title"] + u" — " + place["city"]["name"]
    else:
        title = event["title"] + u" — " + place["title"]
    if event_type != "theatre" and event_type != "concert":
        event_type = "concert"
    minprice_phrase = GetMinPricePhrase(schedule_info)
    schedule_phrase = GetSchedulePhrase(schedule_info, schedule)
    description = CutDescription(event["description"], 100000)
    short_description = CutDescription(event["description"], 270)
    if not description:
        return None
    pre = u""
    if len(minprice_phrase) > 0:
        pre += minprice_phrase + u" \u20BD. "
    if len(schedule_phrase) > 0:
        pre +=  schedule_phrase
    if len(pre) > 0:
        pre = u"\u0007[" + pre + u"\u0007]"
    serpData = {
        "title": {
            "url": event['url'] + "?from=afisha_text_wizard",
            "text": {
                "__hl": title
            }
        },
        "text": {
            "block" : "extended-text",
            "fullText": {
                "__hl": pre + u" " + description
            },
            "text": {
                "__hl": pre + u" " + short_description
            }
        },
        "counter": {
            "path" : "/snippet/afisha/event/" + event_type
        },
        "url": {
            "url": event['url'] + "?from=afisha_text_wizard"
        },
        "favicon": {
            "domain": "afisha.yandex.ru"
        },
        "path": [
            {
                "url": "//afisha.yandex.ru?from=afisha_text_wizard",
                "text": "Яндекс.Афиша"
            }
        ],
        "type": "pseudo",
        "block": "composite"
    }
    return json.dumps(serpData)
@@);

$FixEvent = Python::FixEvent("(Json?) -> String?", 
@@
def FixEvent(data):
    import json, re
    event = json.loads(data)
    if event["description"]:
        event['description'] = re.sub(r"<[^>^<]*>", "", event["description"])
    if event["title"]:
        event["title"] = re.sub(r"<[^>^<]*>", "", event["title"])
    if event["type"]["code"] != "theatre":
        return json.dumps(event)
    if "participants" not in event:
        event["type"]["code"] = "concert"
        return json.dumps(event)
    has_actors = False
    has_director = False
    for participant in event["participants"]:
        if participant["role"] == "actor":
            has_actors = True
        if participant["role"] == "director":
            has_director = True
    if not (has_actors and has_director):
        event["type"]["code"] = "concert"
    return json.dumps(event)
@@);

$FixPlace = Python::FixPlace("(Json?) -> String?", 
@@
def FixPlace(data):
    import json, re
    place = json.loads(data)
    if place["description"]:
        place['description'] = re.sub(r"<[^>^<]*>", "", place["description"])
    if place["title"]:
        place["title"] = re.sub(r"<[^>^<]*>", "", place["title"])
    return json.dumps(place)
@@);

$SortSchedulePrices = Python::SortSchedulesPrices("(Json?) -> Json?",
@@
def SortSchedulesPrices(schedules):
    import json
    schedules = json.loads(schedules)
    for schedule in schedules:
        schedule["prices"] = sorted(schedule["prices"], key=lambda x: x["value"])
    return json.dumps(schedules)
@@
);

$SortScheduleInfoPrices = Python::SortSchedulesInfoPrices("(Json?) -> Json?",
@@
def SortSchedulesInfoPrices(schedule_info):
    import json
    schedule_info = json.loads(schedule_info)
    schedule_info["prices"] = sorted(schedule_info["prices"], key=lambda x: x["value"])
    return json.dumps(schedule_info)
@@
);

$cook_text_wizard = ($event, $place, $schedule, $schedule_info) -> {
    RETURN
    ToBytes(
        Yson::SerializeJson($PrepareTextSnippet($event, $place, $schedule, $schedule_info))
    )
};

$cook_afisha_doc = ($event, $place, $schedule, $schedule_info, $rank) -> {
    RETURN
    ToBytes(
        Yson::SerializeJson(
            Yson::From(
                AsStruct(
                    $event as event,
                    $place as place,
                    $schedule as schedule,
                    $schedule_info as schedule_info,
                    $rank as rank
    ))))
};

$get_string = ($text) -> {
    $tmp = Yson::ConvertToString($text);
    return case
    when ($tmp is null)
    then ""
    else Unwrap($tmp)
    end
};

$create_node = ($text, $type) -> {
    return
    AsStruct(
        $text as value,
        $type as type
    );
};

$delete_docs = ($event, $place, $rank) -> {
    return
    AsList(
        AsStruct(
            Yson::ConvertToString($event{"id"}) as url
        )
    );
};

$create_docs = ($event, $place, $schedule, $schedule_info, $rank) -> {
    return
    AsList(
        AsStruct(
            Yson::ConvertToString($event{"id"}) as url,
            $create_node($get_string($event{"title"}), "#z") as title,
            ListMap(Yson::ConvertToList($event{"synonyms"}),
                ($x) -> { RETURN $create_node($get_string($x), "#z"); }) as z_synonyms,
            $create_node($get_string($place{"title"}), "#z") as z_place_title,
            ListMap(Yson::ConvertToList($place{"synonyms"}),
                ($x) -> { RETURN $create_node($get_string($x), "#z"); }) as z_place_synonyms,
            $create_node($get_string($place{"address"}), "#z") as z_address,
            $create_node($get_string($place{"city"}{"name"}), "#z") as z_city_title,
            $create_node(CAST(Yson::ConvertToString($place{"city"}{"id"}) as int), "#ip") as i_city_geoid,
            $create_node($cook_afisha_doc($event, $place, $schedule, $schedule_info, $rank), "#p") as AfishaJSON,
            $create_node($rank, "#pf") as rating,
            $create_node("test_val", "#h") as afisha_event,
            $create_node(
                $cook_text_wizard(
                    Yson::SerializeJson($event),
                    Yson::SerializeJson($place),
                    Yson::SerializeJson($schedule),
                    Yson::SerializeJson($schedule_info)
                ),
                "#p"
            ) as afisha_text_wizard
        )
    );
};

$create_yson_rtyserver =
    Yson::From(
        AsStruct(
            "modify" as action,
            0 as prefix,
            $create_docs(
                        Yson::ParseJson($FixEvent(Yson::SerializeJson(event))),
                        Yson::ParseJson($FixPlace(Yson::SerializeJson(place))),
                        Yson::ParseJson($SortSchedulePrices(Yson::SerializeJson(schedule))),
                        Yson::ParseJson($SortScheduleInfoPrices(Yson::SerializeJson(schedule_info))),
                        rank
            ) as docs
        )
    );

insert into [%OUTPUT_TABLE%]
WITH TRUNCATE

select
    Yson::SerializeText(
        $create_yson_rtyserver
    ) as DebugField,
    ToBytes(
        Yson::SerializeJson(
            $create_yson_rtyserver
        )
    ) as JsonMessage
from [%INPUT_TABLE%]
where Yson::ConvertToString(event{"type"}{"code"}) != "cinema" and $only_rub_price_currency(Yson::SerializeJson(schedule));
