# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.sandboxsdk import environments
from sandbox.projects.geosearch import resource_types as geo_types

import os


class UpdateGeosearchAfishaBin(sdk2.Task):
    """
    Collects fresh and top afisha events from YT and updates metrics bin
    """

    class Parameters(sdk2.Task.Parameters):
        schedules_table = sdk2.parameters.String("Afisha schedules table", default='//home/afisha/export/production/schedules', required=True)
        server = sdk2.parameters.String("YT server", default='hahn', required=True)
        updater = sdk2.parameters.Resource(
            'Updater script',
            resource_type=geo_types.GEOSEARCH_AFISHA_BIN_UPDATER,
            required=True
        )

    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', '0.7.34.post0', use_wheel=True),
        ]

    def on_execute(self):
        updater = str(sdk2.ResourceData(self.Parameters.updater).path)

        token = sdk2.Vault.data('mesherin', 'YQL_TOKEN')
        exec_args = [updater, '--token', token, '--cluster', self.Parameters.server, '--table', self.Parameters.schedules_table]
        proc_err = os.path.join(str(self.log_path()), 'process_dump.err')
        sp.check_call(exec_args, stderr=open(proc_err, 'w'))
