from sandbox import sdk2
from sandbox.projects.geosearch.BuildGeosearchIndexCountsProxy import BuildGeosearchIndexCountsProxy
from sandbox.projects.resource_types import ADDRS_BUSINESS_SHARDMAP
from sandbox.projects.geosearch.BuildGeosearchIndexCounts import IdxConverterExecutable
from sandbox.common.types.task import Status

# Get resource from parameter pair which describe release type or fixed resource.
# name is the release type parameter
# name + '_resource' is the fixed resource parameter


def get_resource(self, name):
    release_status = getattr(self.Parameters, name)
    if release_status == 'fixed':
        return getattr(self.Parameters, name + '_resource')
    return sdk2.Resource.find(
        resource_type=sdk2.Resource[
            getattr(type(self).Parameters, name + '_resource').resource_type
        ],
        attrs={'released': release_status}
    ).order(-sdk2.Resource.id).first()


class UpdateGeosearchIndexCounts(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        ram = 1 * 1024
        disk_space = 1 * 1024

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.String('Release status', required=True) as release_status:
            release_status.values['stable'] = 'stable'
            release_status.values['testing'] = 'testing'
            release_status.values['unstable'] = 'unstable'

        with sdk2.parameters.Group('Data parameters') as data_parameters:
            with sdk2.parameters.String('Business shards', required=True) as business_shards:
                business_shards.values['stable'] = 'stable'
                business_shards.values['testing'] = 'testing'
                business_shards.values['fixed'] = 'fixed'
            with business_shards.value['fixed']:
                business_shards_resource = sdk2.parameters.Resource(
                    'Business shards resource',
                    resource_type=ADDRS_BUSINESS_SHARDMAP,
                    required=True
                )

            with sdk2.parameters.String('Index converter') as index_converter:
                index_converter.values['stable'] = 'stable'
                index_converter.values['testing'] = 'testing'
                index_converter.values['fixed'] = 'fixed'
            with index_converter.value['fixed']:
                index_converter_resource = sdk2.parameters.Resource(
                    'Index converter resource',
                    resource_type=IdxConverterExecutable,
                    required=True
                )

    class Context(sdk2.Context):
        subtask_launched = False

    def on_execute(self):
        if self.Context.subtask_launched:
            self.release_index_counts()
            return
        shard_map_resource = get_resource(self, 'business_shards')
        idx_converter_resource = get_resource(self, 'index_converter')
        sub_task = BuildGeosearchIndexCountsProxy(
            self,
            description='Build counts for shard map ',
            shard_task=shard_map_resource.task,
            idx_converter_resource=idx_converter_resource
        )
        self.Context.subtask_launched = True
        raise sdk2.WaitTask(sub_task.enqueue(), Status.Group.FINISH | Status.Group.BREAK, True)

    def release_index_counts(self):
        self.server.release(
            task_id=self.find().first().id,
            subject='Index counts update',
            type=self.Parameters.release_status)
