import logging

from sandbox import sdk2
from sandbox.sdk2 import svn

import os
import re

DISCLAIMER = "//It's autogenerated file. Do not edit it manually!"


def generate_include(path):
    path = path.replace(".proto", ".pb.h")
    return '#include <{path}>'.format(path=path)


def generate_includes_for_dir(path, root_for_includes):
    paths = []
    for file_name in os.listdir(path):
        if file_name.endswith(".proto"):
            file_path = os.path.join(root_for_includes, file_name)
            paths.append(file_path)
    paths.sort()

    res = ""
    for p in paths:
        res += generate_include(p) + "\n"
    return res


def generate_all_includes(actual_root, root_for_includes, dir_list):
    res = ""
    for dir_name in dir_list:
        dir_path = os.path.join(actual_root, dir_name)
        dir_for_include = os.path.join(root_for_includes, dir_name)
        res += generate_includes_for_dir(dir_path, dir_for_include) + "\n"
    return res


def register_extensions_from_file(path):
    res = ""
    proto_text = open(path, 'r').read()

    package_line = proto_text[proto_text.find('package') + 8:proto_text.find(';')]
    package_name = "::" + package_line.replace(".", "::")
    for extend_block in re.findall('extend.*\n{\n(?:[^{}]*\n)*}', proto_text):
        for extension_line in extend_block.split('\n'):
            extension_line = extension_line.strip()
            if extension_line.startswith("optional"):
                metadata_name = extension_line.split(' ')[1].split('.')[-1]
                res += "        " + package_name + "::" + metadata_name + "{};\n"

    return res.rstrip()


def generate_extensions_for_dir(path):
    paths = []
    for file_name in os.listdir(path):
        if file_name.endswith(".proto"):
            file_path = os.path.join(path, file_name)
            paths.append(file_path)
    paths.sort()

    res = ""
    for p in paths:
        extensions = register_extensions_from_file(p)
        if extensions:
            res += extensions + "\n"

    return res


def generate_all_extensions(actual_root, dir_list):
    res = ""
    for dir_name in dir_list:
        dir_path = os.path.join(actual_root, dir_name)
        extensions = generate_extensions_for_dir(dir_path).rstrip()
        if extensions:
            namespace = "::yandex::maps::proto::" + dir_name
            res += "        using namespace " + namespace + ";\n"
            res += extensions.replace(namespace + "::", "") + "\n\n"
    return res


def add_disclaimer(file_text):
    if file_text.startswith("#pragma once"):
        return file_text.replace("#pragma once", "#pragma once\n{}\n\n".format(DISCLAIMER))
    else:
        return "{}\n\n{}".format(DISCLAIMER, file_text)


class UpdateGeosearchPbExtensions(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.String('revision', default=None, description='Arcadia revision')

    def on_execute(self):
        pbreport_lib_path = str(self.path("pbreport"))
        maps_protos_path = str(self.path("maps_proto"))
        proto_dirs = ["search", "common2", "arrival", "atom", "uri"]
        proto_dirs.sort()

        svn.Arcadia.checkout('arcadia:/arc/trunk/arcadia/extsearch/geo/kernel/pbreport',
                             pbreport_lib_path,
                             revision=self.Parameters.revision)

        svn.Arcadia.checkout('arcadia:/arc/trunk/arcadia/maps/doc/proto/yandex/maps/proto',
                             maps_protos_path,
                             revision=self.Parameters.revision)

        includes = generate_all_includes(maps_protos_path, "yandex/maps/proto/", proto_dirs)
        header_template = open(os.path.join(pbreport_lib_path, "codegen/pb.h.template"), 'r').read()
        header_text = header_template.replace("// Place for includes", includes.strip())
        header_text = add_disclaimer(header_text)
        header_file = open(os.path.join(pbreport_lib_path, "pb.h"), 'w')
        header_file.write(header_text)
        header_file.close()

        extensions = generate_all_extensions(maps_protos_path, proto_dirs)
        src_template = open(os.path.join(pbreport_lib_path, "codegen/pb.cpp.template"), 'r').read()
        src_text = src_template.replace("// Place for init extensions", extensions.strip())
        src_text = add_disclaimer(src_text)
        src_file = open(os.path.join(pbreport_lib_path, "pb.cpp"), 'w')
        src_file.write(src_text)

        src_file.close()

        try:
            sdk2.svn.Arcadia.commit(pbreport_lib_path,
                                    "Update geosearch pb extensions",
                                    user='zomb-sandbox-rw')
        except svn.SvnError as err:
            logging.info('Commit failed:\n{}'.format(str(err)))
