from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.projects.geosearch.BuildGeosearchTransitGzt import BuildGeosearchTransitGzt


class UpdateGeosearchTransitGzt(BuildGeosearchTransitGzt):
    """
        Build and release gazetteer with route numbers for transit rule in begemot
    """

    def on_execute(self):
        if self.Context.subtasks:
            subtasks = list(self.find(id=self.Context.subtasks).limit(len(self.Context.subtasks)))
        else:
            subtasks = None
        if not subtasks:
            subtasks = []
            subtask = BuildGeosearchTransitGzt(self, description="Build transit gzt", create_sub_task=False)
            subtask.Parameters.builder = self.Parameters.builder
            subtask.save()
            subtasks.append(subtask.enqueue())
            if subtasks:
                self.Context.subtasks = map(lambda _: _.id, subtasks)
            raise sdk2.WaitTask(subtasks,
                                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                                wait_all=True)
        else:
            self.server.release(task_id=self.Context.subtasks[0],
                                type=ctt.ReleaseStatus.PRESTABLE,
                                subject="Release transit gzt")
