# -*- coding: utf-8 -*-

import sandbox.common.types.misc as ctm

from sandbox.projects.geosearch.resource_types import MAPS_DATABASE_FAST_FEATURES, MAPS_DATABASE_FAST_FEATURES_SHARDED
from sandbox.projects.geosearch.BuildMapsFastFeatures import BuildMapsFastFeatures as build_task, OutputResourceType

from sandbox.projects.common.geosearch.indexing import generate_base_update_task

BaseUpdate = generate_base_update_task(
    build_task=build_task,
    index_type_for_timestamp=None,
    release_subject="ADDRS Fast features update"
)


class UpdateMapsDatabaseFastFeatures(BaseUpdate):
    """
        Update maps database fast+features: ask fast_features.pb.gz status, download, build index and publish it if required.
    """
    type = 'UPDATE_MAPS_DATABASE_FAST_FEATURES'
    dns = ctm.DnsType.DNS64

    def on_execute(self):
        output_type = MAPS_DATABASE_FAST_FEATURES if self.ctx[OutputResourceType.name] == 'MAPS_DATABASE_FAST_FEATURES' else MAPS_DATABASE_FAST_FEATURES_SHARDED
        self.time_reference_type = output_type
        BaseUpdate.on_execute(self)


__Task__ = UpdateMapsDatabaseFastFeatures
