import logging
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk import environments
from sandbox.projects.geosearch.UploadEdaWizards.PrepareEdaWizards import PrepareWizardsExecutable


class FilterEdaWizards(sdk2.Task):
    ''' Task for updating eda wizards from organic '''

    class Parameters(sdk2.Parameters):
        prepare_wizards_executable = sdk2.parameters.Resource(
            'prepare_wizards_executable',
            resource_type=PrepareWizardsExecutable,
            required=True
        )
        config = sdk2.parameters.JSON('config', required=True)

    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment("yandex-yt")
        ]

    def execute_cmd(self, executable_parameter, cmd_params, log_name):
        executable = str(sdk2.ResourceData(executable_parameter).path)
        logging.info('Run command: {}'.format(' '.join([executable] + cmd_params)))
        with sdk2.helpers.ProcessLog(self, logger=log_name) as l:
            sp.check_call([executable] + cmd_params, stdout=l.stdout, stderr=l.stderr)

    def on_execute(self):
        yt_token = sdk2.Vault.data(self.owner, 'yt-token')
        os.environ["MR_RUNTIME"] = "YT"
        os.environ["YT_TOKEN"] = yt_token

        self.execute_cmd(
            self.Parameters.prepare_wizards_executable, ['EDA_URLS', '--output-dir', '//home/geo-search/maxim98/eda/'], 'filters eda urls'
        )
