import logging
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk import environments

class PrepareWizardsExecutable(sdk2.Resource):
    ''' Utility that prepares eda-wizards from organic urls'''
    executable = True
    releasable = True
    releasers = ["maxim98"]

class PrepareEdaWizards(sdk2.Task):
    ''' Task for updating eda wizards from organic '''

    class Parameters(sdk2.Parameters):
        prepare_wizards_executable = sdk2.parameters.Resource(
            'prepare_wizards_executable',
            resource_type=PrepareWizardsExecutable,
            required=True
        )
        config = sdk2.parameters.JSON('config', required=True)

    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment("yandex-yt")
        ]

    def execute_cmd(self, executable_parameter, cmd_params, log_name):
        executable = str(sdk2.ResourceData(executable_parameter).path)
        logging.info('Run command: {}'.format(' '.join([executable] + cmd_params)))
        with sdk2.helpers.ProcessLog(self, logger=log_name) as l:
            sp.check_call([executable] + cmd_params, stdout=l.stdout, stderr=l.stderr)

    def on_execute(self):
        yt_token = sdk2.Vault.data(self.owner, 'yt-token')
        os.environ["MR_RUNTIME"] = "YT"
        os.environ["YT_TOKEN"] = yt_token

        self.execute_cmd(
            self.Parameters.prepare_wizards_executable, ['GET', '--output-file', 'path_info_menu.tsv', '--output-dir', '//home/geo-search/maxim98/eda/'], 'get info about wizards'
        )
        self.execute_cmd(
            self.Parameters.prepare_wizards_executable, ['CONVERT', '--input-file', 'path_info_menu.tsv', '--output-file', 'path_wizard.tsv'], 'convert all info to the wizard format'
        )
        self.execute_cmd(
            self.Parameters.prepare_wizards_executable, ['UPLOAD', '--input-file', 'path_wizard.tsv', '--output-table', '//home/geo-search/maxim98/eda_upload'], 'Upload wizards to the output table'
        )
