# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.sandboxsdk import environments
from sandbox.projects.geosearch import resource_types as geo_types
from sandbox.projects import resource_types

import os


class UploadTopRubrics(sdk2.Task):
    """
    Publish categories_inside/1.x for toponyms to SaaS
    """

    class Parameters(sdk2.Task.Parameters):
        server = sdk2.parameters.String("YT server", default='hahn', required=True)
        preparer = sdk2.parameters.Resource(
            'Dump preparer',
            resource_type=geo_types.TOP_RUBRICS_PREPARER,
            required=True
        )
        skip_prepare = sdk2.parameters.Bool("Skip prepare phase", default=False)
        dumper = sdk2.parameters.Resource(
            'SaaS uploader',
            resource_type=resource_types.DUMP_TO_INDEXERPROXY_EXECUTABLE,
            required=True
        )
        indexer = sdk2.parameters.String("SaaS indexer url", default='saas-indexerproxy-maps-kv.yandex.net', required=True)
        geosrc = sdk2.parameters.Resource(
            'Toponym source data (geosrc)',
            resource_type=resource_types.MAPS_DATABASE_GEOSRC,
            required=True
        )
        rubrics_table = sdk2.parameters.String("Top rubrics table", default='//home/geosearch/mesherin/geoid_top_rubrics', required=False)

    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', '0.7.34.post0', use_wheel=True),
        ]

    def on_execute(self):
        preparer = str(sdk2.ResourceData(self.Parameters.preparer).path)
        geosrc = str(sdk2.ResourceData(self.Parameters.geosrc).path)
        token = sdk2.Vault.data('mesherin', 'YQL_TOKEN')
        saas_dump_table = '//home/geosearch/mesherin/top_rubrics_saas_dump'
        prep_err = os.path.join(str(self.log_path()), 'upload_top_rubrics.err')
        exec_args = [preparer, geosrc, saas_dump_table]

        if self.Parameters.rubrics_table:
            exec_args.extend(['--rubrics', self.Parameters.rubrics_table])

        os.environ['MR_RUNTIME'] = 'YT'
        os.environ['YT_TOKEN'] = token

        if not self.Parameters.skip_prepare:
            sp.check_call(exec_args, stderr=open(prep_err, 'w'))

        indexer = self.Parameters.indexer
        dumper = str(sdk2.ResourceData(self.Parameters.dumper).path)

        dump_err = os.path.join(str(self.log_path()), 'dump_to_indexerproxy.err')
        upload_params = [
            dumper,
            '--mode', 'mr',
            '-k', '0965dcc45da238136de79a1b71a89133',
            '-h', indexer,
            '--mr-server', self.Parameters.server,
            '--mr-input', saas_dump_table,
            '--mr-output', saas_dump_table + '.err',
            '--mr-processor', 'cards_geo',
            '--mr-processor-env', 'categories_inside/1.x',
            '--prefix', '1',
            '--action', 'atModify',
            '-l', '4',
        ]
        sp.check_call(upload_params, stderr=open(dump_err, 'w'))
