# -*- coding: utf-8 -*-
import os
from shutil import copyfile, copytree

from sandbox.sandboxsdk.paths import make_folder as mkdir
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.svn import ArcadiaTestData
from sandbox.projects.common.geosearch.search_components import GeoMetaSearchUpper


def get_resource(sb_task, resource):
    path = sb_task.sync_resource(resource)
    return path


def get_config():
    test_data_arcadia_url = 'arcadia:/arc/trunk/arcadia_tests_data'
    svn_subpath = 'geosearch/sandbox_test_data/geometasearch/sandboxhost--8031.cfg'
    svn_path = os.path.join(test_data_arcadia_url, svn_subpath)
    config_path = ArcadiaTestData.get_arcadia_test_data(channel.task, svn_path)
    return config_path


def launch(sb_task, binary_resource, data_resource, geodata_resource):
    binary_path = get_resource(sb_task, binary_resource)
    rearr_dir = get_resource(sb_task, data_resource)
    data_dir = mkdir(channel.task.abs_path() + '/geometasearch_data')
    copytree(rearr_dir, os.path.join(data_dir, os.path.basename(rearr_dir)))
    geodata = get_resource(sb_task, geodata_resource)
    os.chmod('%s/data/geosearch/' % data_dir, 0777)
    copyfile(geodata, '%s/data/geosearch/%s' % (data_dir, os.path.basename(geodata)))
    config_path = get_config()
    auxsources_upper = {}
    searchsources_upper = {}
    searchsources_upper['Geo'] = 'http://addrs-testing.search.yandex.net/middle/stable'
    searchsources_upper['GeoMisspell'] = searchsources_upper['Geo']
    auxsources_upper['Misspell'] = 'http://misc-spell.yandex.net:19036/misspell.json/check'
    reqans_log = sb_task.create_resource('reqans log',
                                         'geometasearch_reqans.log',
                                         'GEOMETASEARCH_REQANS_LOG',
                                         arch='any')
    upper_output = sb_task.create_resource('upper stdout/stderr',
                                           'geometasearch_upper_output.txt',
                                           'GEOMETASEARCH_OUTPUT',
                                           arch='any')
    upper = GeoMetaSearchUpper(work_dir=channel.task.abs_path(),
                               searchsources=searchsources_upper,
                               auxsources=auxsources_upper,
                               binary=binary_path,
                               config_file=config_path,
                               rearrange_dir=os.path.join(data_dir, 'data/'),
                               port=8031,
                               event_log=None,
                               load_log=None,
                               reqans_log_resource=reqans_log,
                               output_resource=upper_output,
                               use_few_threads=False,
                               disable_timeouts=False)
    upper.start()
    return upper
