# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class GEOSEARCH_DRUG_STOPWORDS(sdk2.Resource):
    """
        Специфические стоп-слова для поиска по лекарствам.
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class MAPS_DATABASE_WIZARD_GEODRUGS(sdk2.Resource):
    """
        Данные бегемотного правила GeoDrugs
    """
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    releasable = True
    mark = sdk2.parameters.String("Mark for nanny downloader")


class GEOSEARCH_AFISHA_BIN_UPDATER(sdk2.Resource):
    """
        Питоновский скрипт, обновляющий корзину по событиям
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/fast_features/update_afisha_bin/update_afisha_bin'


class DISTRICTS_PREPARER(sdk2.Resource):
    """
        Бинарь, готовящий таблицу для заливки данных Яндекс.Района в SaaS
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/saas_snippets/prepare_district/prepare_district'


class TOP_RUBRICS_PREPARER(sdk2.Resource):
    """
        Бинарь, готовящий таблицу для заливки топа рубрик по топониму в SaaS
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/saas_snippets/top_rubrics/top_rubrics'


class INNER_ORGS_PREPARER(sdk2.Resource):
    """
        Бинарь, готовящий таблицу со сниппетами внутренних организаций и рубрик для заливки в SaaS
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/inner_orgs/publish_inner_orgs/publish_inner_orgs'


class TOPONYM_HOTELS_PREPARER(sdk2.Resource):
    """
        Бинарь, готовящий таблицу для заливки сниппета has_yandex_travel в SaaS
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/saas_snippets/toponym_hotels/toponym_hotels'


class GEOSEARCH_STANDALONE_INDEXER(sdk2.Resource):
    """
        Утилита для варки индекса базового поиска на YT
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_INDEX_DOWNLOADER(sdk2.Resource):
    """
        Утилита для скачки шардов из YT
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_YT_URL_PARSER(sdk2.Resource):
    """
        Утилита для скачки URL из YT
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_YT_INDEXER_CONFIGS(sdk2.Resource):
    """
        Конфиги для варки индекса базового поиска на YT
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_YT_DATA_PREPARER(sdk2.Resource):
    """
        Бинарь для подготовки вспомогательных данных для индексатора (статические факторы, внутренние организации, и т. д.)
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/business_indexer_yt/prepare_data/prepare_data'


class GEOSEARCH_OBJECTS_INDEXER(sdk2.Resource):
    """
        Индексатор поиска по объектам
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/objects/yandex-geosearch-indexer-objects'


class GEOSEARCH_PANTHER_IDX_CONVERTER(sdk2.Resource):
    """
        Утилита для создания пантерного индекса
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/panther/tools/idx_convert/idx_convert'


class GEOSEARCH_PANTHER_SQ_CONVERTER(sdk2.Resource):
    """
        Утилита для создания пантерного индекса
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/panther_sq_converter/panther_sq_conv'


class GEOSEARCH_PANTHER_ATTR_SQ_CONVERTER(sdk2.Resource):
    """
        Утилита для создания атрибутного пантерного индекса
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/panther_attr_sq_converter/panther_attr_sq_conv'


class INNER_ORGS_CALCER(sdk2.Resource):
    """
        Бинарь, готовящий таблицу с организациями в организациямх
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/inner_orgs/calc_inner_orgs/calc_inner_orgs'


class DRUGS_GZT_BUILDER(sdk2.Resource):
    """
        Бинарь, строящий газеттир для бегемотного правила GeoDrugs
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/fast_features/create_drugs_gzt/create_drugs_gzt'


class GZT_BUILDER(sdk2.Resource):
    """
        Бинарь, строящий гатеттир для бегемотного правила PPO
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/wizard/ppo/gzt_builder/gzt_builder'


class PORTO_LAYER_ADDRS_GEOCODER(sdk2.Resource):
    '''
        Слой с бинарником геокодера
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class PORTO_LAYER_ADDRS_TRANSIT(sdk2.Resource):
    '''
        Слой с бинарником транзита
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class FAST_EXPORT_SPEED_MEASURE(sdk2.Resource):
    '''
        Слой с тестом скорости свежести
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/fast_export/measure_speed/measure_speed'


class FAST_EXPORT_COLLECT_CHANGES(sdk2.Resource):
    '''
        Слой со сбором экспортов
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/fast_export/collect_changes/collect_changes'


class FAST_EXPORT_FRESH_STATES_LOGGER(sdk2.Resource):
    '''
        Сбор всех приходящих в свежесть записей в одну таблицу
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/fast_export/fresh_states_logger/fresh_states_logger'


class FAST_EXPORT_CONFIG(sdk2.Resource):
    '''
        Конфиг для свежести
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class SNEZHANNA_CLASSIFIER(sdk2.Resource):
    '''
        Классификатор для робота коллцентра.
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers


class ADDRS_SNIPPETS_BUNDLE(sdk2.Resource):
    '''
        Набор бинарей для генерации геопоисковых сниппетов
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_OBJECTS_INDEX(sdk2.Resource):
    '''
        Индекс объектов внутри организаций
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_OBJECTS_CONFIG(sdk2.Resource):
    '''
        Конфиг базового объектов внутри организаций
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_XSD_SCHEMAS(sdk2.Resource):
    '''
        Архив с XSD схемами для валидации сниппетов
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_DYNAMIC_FORMULA(sdk2.Resource):
    '''
        Geosearch dynamic formula
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_CHAIN_SNIPPET_GENERATOR(sdk2.Resource):
    '''
        Генератор сниппетов для карточки сети
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/chain_snippet_generator'


class ADDRS_RBTORRENT_SHARDMAP(sdk2.Resource):
    '''
        Шардмап с геопоисковой базой
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class NANNY_DOWNLOADER_EXECUTABLE(sdk2.Resource):
    '''
        nanny_downloader executable
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/production/downloader/bin'


class MAPS_DATABASE_FAST_FEATURES(sdk2.Resource):
    """
        Индекс быстрофичей (.mms)
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_MIDDLE_FORMULA_DIR(sdk2.Resource):
    """
        Ресурс для быстрого релиза экспериментальных формул ранжирования (L3)
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_formulas_releasers


class GEOSEARCH_MIDDLE_ACCEPTANCE_FORMULA_DIR(sdk2.Resource):
    """
        Ресурс для приемки формул ранжирования
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_formulas_releasers


class MAPS_DATABASE_FAST_FEATURES_SHARDED(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    shards_count = sdk2.Attributes.String('Total number of shards')  # string for compatibility with SDK1


class MAPS_DATABASE_FAST_FEATURES_SHARD(sdk2.Resource):
    releasable = True
    auto_backup = False
    releasers = resource_releasers.geosearch_releasers
    shard_id = sdk2.Attributes.String('Zero-based number of shard')  # string for compatibility with SDK1
    shards_count = sdk2.Attributes.String('Total number of shards')  # string for compatibility with SDK1


class GEOSEARCH_ACCEPTANCE_EXECUTABLE(sdk2.Resource):
    auto_backup = True


class MAPS_WEB_DOUBLEFRC(sdk2.Resource):
    """
        Сырые данные для построения аннотационного индекса веба для геопоиска
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_WEB_INDEXANN_URL_FILTER(sdk2.Resource):
    """
        Бинарь, фильтрующий урлы Юпитера для построения аннотационного индекса веба
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_CANONIZER_DUMP(sdk2.Resource):
    """
        Экспорт канонизированных урлов из базы геопоиска
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_TASK_MANAGER_SNIPPET_CONVERTER(sdk2.Resource):
    '''
        Конвертор сниппетов xml->pb и xml->json
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/snippet_converter'


class GEOSEARCH_ENCYCLOPEDIA_SNIPPET(sdk2.Resource):
    '''
        Генератор сниппета encyclopedia/1.x
        (конвертирует сниппет entity/1.x в protobuf)
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/task_manager/generators/encyclopedia'


class GEOSEARCH_ENCYCLOPEDIA_2X_SNIPPET_GENERATOR(sdk2.Resource):
    '''
        Генератор сниппета encyclopedia/2.x
        (Далает protobuf из фидов энциклопедии)
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/task_manager/generators/encyclopedia_2x'


class GEOSEARCH_PERSONAL_SCORE_USER_PROFILES_CONVERTER(sdk2.Resource):
    '''
        Конвертер юзерпрофилей геоперсскора для заливки в kvSaaS
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/task_manager/generators/personal_score_user_profiles'


class MAPS_SEARCH_CONFIG_OBJECT(sdk2.Resource):
    """
        Config for object basesearch
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class SIMILAR_ORGS_TABLE(sdk2.resource.AbstractResource):
    """
        Путь до YT таблицы, содержащей пермалинки похожих организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_IMPORTER(sdk2.Resource):
    """
        Утилита для помошника по снятию серпов с геопоиска
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_IMPORTER_2(sdk2.Resource):
    """
        Directory containing importer2 files
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_SNIPPETS_MONITORING(sdk2.Resource):
    """
        Geosnippets moniroting  tool
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GENERATE_GOODS_SNIPPETS_EXECUTABLE(sdk2.Resource):
    """
        Tool for generating goods/1.x snippets
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/goods_snippets/generate_goods'


class GENERATE_GOODS_REGISTER_EXECUTABLE(sdk2.Resource):
    """
        Tool for generating goods_register
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/goods_snippets/generate_goods_register'


class GEOSEARCH_BAD_URLS_PREPARER(sdk2.Resource):
    """
        Bad urls snippets calculating for task manager
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/bad_urls_preparer'


class GEOSEARCH_PACKED_URL_TRIES(sdk2.Resource):
    """
        Bad urls snippets calculating for task manager
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class ADDRS_BASE_YP_SHARDMAP(sdk2.Resource):
    '''
        Шардмап с геопоисковой базой для базовых в YP
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class SIMILAR_ORGS_MERGER(sdk2.Resource):
    """
        Tool for merging custom similar orgs into main ones
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/similar_orgs/merge_similar_orgs'


class GEOSEARCH_FUEL_SNIPPET_EXECUTABLE(sdk2.Resource):
    """
        Tool for generating fuel/1.x
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/fuel_snippet'


class EVLOGVIEW_EXECUTABLE(sdk2.Resource):
    """
        evlogview executable
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers


class GEOSEARCH_CPU_STAT_COLLECTOR(sdk2.Resource):
    """
        Tool for collecting cpu stat from logfeller tables and upload it to statface
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/cpu_stat_collector'


class ADDRS_BASE_AUTORELEASE_DUMP(sdk2.Resource):
    '''
        Дамп данных автоприемки
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_RPS_STAT_CALCER(sdk2.Resource):
    """
        Tool for printing report about RPS of specific client or for all client for custom period
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/cpu_and_quota_tools/client_stat'


class GEOSEARCH_STATIC_FACTPRS_DOCURL(sdk2.Resource):
    """
        Static docurl factors
    """
    releasable = True
    auto_backup = True
    realesers = resource_releasers.geosearch_releasers


class ADDRS_TESTING_BALANCER_GENERATOR(sdk2.Resource):
    """
        Binary for addrs-testing AWACS namespace generation
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/production/balancer/bin'


class GEOSEARCH_DJ_SHARD_2_MODELS(sdk2.Resource):
    """
        Models for geosearch personal score
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_DJ_SHARD_2_MODEL(sdk2.Resource):
    """
        Single model for geosearch personal score
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_DJ_SHARD_2_RESOURCE_BUNDLE(sdk2.Resource):
    """
        Resource bundle for geosearch personal score djSaaS
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_DJ_BASESEARCH_BIN(sdk2.Resource):
    """
        DJ basesearch binary
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/dj/tools/basesearch'


class GEOSEARCH_DJ_SHARD(sdk2.Resource):
    """
        Shard geosearch personal score djSaaS
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_DRUG_FORMS(sdk2.Resource):
    """
        Краткие лекарственные формы для визарда
    """
    releasable = True
    auto_backup = True
    realesers = resource_releasers.geosearch_releasers


class GEOSEARCH_TRANSIT_GZT(sdk2.Resource):
    """
        Gazetteer with routes for transit rule in begemot
    """
    releasable = True
    auto_backup = True
    realesers = resource_releasers.geosearch_releasers


class GEOSEARCH_TRANSIT_GZT_BUILDER(sdk2.Resource):
    """
        Tool for GEOSEARCH_TRANSIT_GZT build
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/build_transit_fixlist'


class GEOSEARCH_UPDATE_FAST_FEATURE_VALUES(sdk2.Resource):
    """
        Tool for fast feature values preparation
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/sprav/fast_features/update_fast_feature_values'


class GEOSEARCH_FAST_SNIPPETS_EXECUTABLE(sdk2.Resource):
    """
        Executable of service for fast snippets upload
    """
    releasable = True
    auto_backup = True
    executable = True
    realesers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/fast_snippets/bin'


class GEOSEARCH_FAST_SNIPPETS_SERVICE_CONFIG(sdk2.Resource):
    """
        Common fast snippet service config
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_FAST_SNIPPETS_CONFIG(sdk2.Resource):
    """
        Snippet configs for upload over fast snippet service
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_CHAINS_SPLIT_BY_CITIES_EXECUTABLE(sdk2.Resource):
    '''
        Split chains export by city geoids
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/extsearch/geo/tools/split_chains_by_cities'


class GEOSEARCH_DRUG_WHITELIST(sdk2.Resource):
    """
        Drugs whitelist gzt for wizard
    """
    releasable = True
    auto_backup = True
    realesers = resource_releasers.geosearch_releasers


class GEOSEARCH_ENTITY_DATA_PREPARER(sdk2.Resource):
    '''
        Prepares data for entity/1.x snippet
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/prepare_entity'


class GEOSEARCH_FUNDUK_PACKAGE(sdk2.Resource):
    '''
        Package with funduk jar and corresponding JDK
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class GEOSEARCH_TYCOON_EXTRA_DATA_BUILDER(sdk2.Resource):
    '''
        Prepares data for tycoon_extra_data/1.x snippet
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/tycoon_extra_data'


class GEOSEARCH_HOT_WATER_SNIPPET_GENERATOR(sdk2.Resource):
    '''
        Генератор сниппетов графика отключения горячей воды
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/task_manager/generators/hot_water'


class GEOSEARCH_SNIPPETS_GENERATOR(sdk2.Resource):
    '''
        Общий бинарь с командами для сборки сниппетов
    '''
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/task_manager/generators/runner/bin/generate_snippets'


class MAKE_ADDRSNIP_DATA_EXECUTABLE(sdk2.Resource):
    """
        Бинарь, готовящий данные адресных сниппетов
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/addrsnippet/make_addrsnip_data'


class ADDRSNIP_NORMALIZE_URL_EXECUTABLE(sdk2.Resource):
    """
        Бинарь, нормализующий урлы для адресных сниппетов
    """
    auto_backup = True
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/org1_wizard_by_aggregators/normalize_url/normalize_url'


class GEOSEARCH_FEATURES(sdk2.Resource):
    """
        Pbs file in geosearch shard with meta information about features and fast features
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class GEOSEARCH_PERSCLICK_SHARD(sdk2.Resource):
    """
        Shard geosearch personal clicks
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


class GENERATE_FULLOBJECTS_EXECUTABLE(sdk2.Resource):
    """
        Tool for preprocessing fullobjects/1.x snippets
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/goods_snippets/generate_fullobjects'


class GEOMETASEARCH_CONFIGS_BUILDER(sdk2.Resource):
    """
        Tool for metasearch configs building
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'arcadia/search/geo/tools/production/geometasearch_configs_builder'


class GEOSEARCH_MOVED_COLLAPSER_DUMP(sdk2.Resource):
    """
        Binary file with saved TMovedCollapser data for freshness build
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
