import requests


def get_service_duty_logins(abc_service_id, parameters, abc_token, check_status=False):
    url = 'https://abc-back.yandex-team.ru/api/v4/services/{}/on_duty/'.format(abc_service_id)
    headers = {'Authorization': 'OAuth {token}'.format(token=abc_token)}

    resp = requests.get(url, params=parameters, headers=headers)
    if check_status:
        resp.raise_for_status()

    return [
        str(entry['person']['login'])
        for entry in resp.json()
    ]
