import logging


def get_source_time(yt_client, source_path):
    import yt.wrapper as yt
    from yt.common import date_string_to_datetime

    def get_time(attribute):
        attribute_path = yt.ypath_join(source_path, '@{}'.format(attribute))
        if not yt.exists(attribute_path, client=yt_client):
            return None
        time_str = yt.get(attribute_path, client=yt_client)
        return date_string_to_datetime(time_str) if time_str else None

    return get_time('source_time') or get_time('modification_time')


def fallback_path(fallback_dir, path):
    import yt.wrapper as yt
    return yt.ypath_join(fallback_dir, yt.ypath_split(path)[-1])


def fallback_source(yt_client, fallback_dir, source_path):
    path, time = None, None

    for candidate_path in (source_path, fallback_path(fallback_dir, source_path)):
        candidate_time = get_source_time(yt_client, candidate_path)

        logging.debug('Source time on %s: %s (%s)', yt_client.config['proxy']['url'],
                      candidate_time or 'not found', candidate_path)
        if candidate_time and (not time or candidate_time > time):
            path, time = candidate_path, candidate_time

    return path, time
