# -*- coding: utf-8 -*-
import requests


def get_groups(service):
    url = 'http://nanny.yandex-team.ru//v2/services/%s/runtime_attrs/instances/' % service
    data = requests.get(url, verify=False).json()
    groups = data['content']['extended_gencfg_groups']['groups']
    return {group['name']: group['release'] for group in groups}


def get_limit(service, limit_name):
    limits = []
    url_tpl = 'http://api.gencfg.yandex-team.ru/{topology}/searcherlookup/groups/{group}/instances'
    for group, topology in get_groups(service).iteritems():
        url = url_tpl.format(topology=topology, group=group)
        data = requests.get(url).json()
        limits.append(data['instances'][0]['porto_limits'][limit_name])
    return min(limits)
