# -*- coding: utf-8 -*-

import os
import shutil

from sandbox import sdk2

from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import copy_path


def download_sharded_index(index_shardmap, destination_path, files=None):
    if not index_shardmap:
        return 0

    index = destination_path or './index'
    if os.path.exists(index):
        shutil.rmtree(index)
    index_task = index_shardmap.task
    shard_tasks = index_task.Context.register_tasks
    shard_count = len(shard_tasks)
    for shard_id in xrange(shard_count):
        shard_resource = sdk2.Resource[resource_types.ADDRS_BUSINESS_SHARD].find(task=sdk2.Task[shard_tasks[shard_id]]).first()
        resource_path = str(sdk2.ResourceData(shard_resource).path)
        shard_path = os.path.join(index, str(shard_id))
        if not files:
            copy_path(resource_path, shard_path)
        else:
            for fname in files:
                copy_path(os.path.join(resource_path, fname), os.path.join(shard_path, fname))

    return shard_count
