# -*- coding: utf-8 -*-

import re
import json


class EventlogFrame(object):

    def __init__(self, frame_id, req_id, request):
        self.id = frame_id
        self.req_id = req_id
        self.request = request
        self.error = None

    def set_error(self, error_text):
        self.error = error_text

    def has_errors(self):
        return bool(self.error)

    def clean_request(self):
        rgx = re.compile(r'^(ruid|remote_ip|reqid|req_path).*$')
        cleaned_request = ''
        for part in self.request.split('&'):
            if not rgx.match(part):
                cleaned_request += part
                cleaned_request += '&'
        return cleaned_request.strip('&')

    def dump(self):
        return {
            'req_id': self.req_id,
            'request': self.request,
            'clened_request': self.clean_request()
        }


def extract_error_text(line):
    return ' '.join(line.split()[4:])


def parse_eventlog_file(file_path):
    with open(file_path) as logfile:
        frames = {}
        frame = None
        for line in logfile:
            if 'ContextCreated' in line:
                splitted_line = line.split()
                frame_id = splitted_line[1]
                request = splitted_line[3]
                request_id = splitted_line[4]
                frame = EventlogFrame(frame_id, request_id, request)
                continue
            if ('RearrangeError' in line or 'RequesterError' in line) and frame:
                error = extract_error_text(line)
                print error
                frame.set_error(error)
            if 'EndOfFrame' in line:
                if frame and frame.has_errors():
                    if frame.error in frames:
                        frames[error].append(frame.dump())
                    else:
                        frames.update({frame.error: [frame.dump()]})
                    frame = None
        return frames


def dump_parsed(data, file_name):
    with open(file_name, 'w') as out:
        json.dump(data, out)


def compare(reference_data, test_data):
    pass
