# -*- coding: utf-8 -*-

import json
import logging
import requests
from urlparse import urljoin


class NirvanaError(Exception):
    pass


class Nirvana(object):

    def __init__(self, oauth_token):
        self.url = 'https://nirvana.yandex-team.ru/api/public/v1/'
        self.oauth_token = oauth_token
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(self.oauth_token)
        self.session.headers['Content-Type'] = 'application/json'

    def clone_workflow(self, workflow_id, new_name, new_description):
        uri_tpl = ('cloneWorkflow?workflowId={workflow_id}&'
                   'newName={new_name}&'
                   'newDescription={new_description}')
        uri = uri_tpl.format(workflow_id=workflow_id,
                             new_name=new_name,
                             new_description=new_description)
        url = urljoin(self.url, uri)
        logging.info('Trying to clone workflow: %s' % workflow_id)
        try:
            response = self.session.get(url, verify=False).json()
            logging.info('Result: %s' % response)
            print 'Result: %s' % response
            return response['result']
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not clone workflow %s\n Details: %s' % (workflow_id,
                                                                 err)
            raise NirvanaError(msg)

    def start_workflow(self, workflow_id):
        uri = 'startWorkflow?workflowId=%s' % workflow_id
        url = urljoin(self.url, uri)
        logging.info('Trying to start workflow: %s' % workflow_id)
        try:
            response = self.session.get(url, verify=False).json()
            print response
            logging.info('Result: %s' % response)
            return response['result']
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not start workflow %s\n Details: %s' % (workflow_id,
                                                                 err)
            raise NirvanaError(msg)

    def get_workflow_state(self, workflow_id):
        uri = 'getExecutionState?workflowId=%s' % workflow_id
        url = urljoin(self.url, uri)
        logging.info('Trying to start workflow: %s' % workflow_id)
        try:
            response = self.session.get(url, verify=False).json()
            logging.info('Result: %s' % response)
            return response['result']
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not get workflow %s state \n Details: %s' % (workflow_id, err)
            raise NirvanaError(msg)

    def set_workflow_parameters(self, workflow_id, parameters_list):
        uri = 'setGlobalParameters'
        url = urljoin(self.url, uri)
        data = {"jsonrpc": "2.0",
                "method": "setGlobalParameters",
                "params": {'params': parameters_list,
                           'workflowId': workflow_id},
                "id": "set_params_%s" % workflow_id}
        try:
            response = self.session.post(url,
                                         data=json.dumps(data),
                                         verify=False).json()
            print response
            logging.info('Result: %s' % response)
            result = response['result']
            return result
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not set metadata for workflow %s\n Details: %s' % (workflow_id, err)
            raise NirvanaError(msg)

    def get_block_by_name(self, workflow_id, name):
        uri = 'getWorkflow?workflowId=%s' % workflow_id
        url = urljoin(self.url, uri)
        logging.info('Trying to get blocks form workflow: %s' % workflow_id)
        try:
            response = self.session.get(url, verify=False).json()
            logging.info('Result: %s' % response)
            result = response['result']
            target_block = [block['blockGuid'] for block in result['blocks'] if block['name'] == name]
            return target_block[0]
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not get blocks form workflow %s\n Details: %s' % (workflow_id, err)
            raise NirvanaError(msg)

    def delete_block(self, workflow_id, block_id):
        uri = 'removeBlocks'
        url = urljoin(self.url, uri)
        data = {"jsonrpc": "2.0",
                "method": "removeBlocks",
                "params": {'blocks': [{'guid': block_id}],
                           'workflowId': workflow_id},
                "id": "delete_%s" % block_id}
        try:
            response = self.session.post(url,
                                         data=json.dumps(data),
                                         verify=False).json()
            logging.info('Result: %s' % response)
            result = response['result']
            return result
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not delete block %s form workflow %s\n Details: %s' % (block_id, workflow_id, err)
            raise NirvanaError(msg)

    def get_blocks_results(self, workflow_id):
        uri = 'getBlockResults?workflowId=%s' % workflow_id
        url = urljoin(self.url, uri)
        logging.info('Trying to get blocks results form workflow: %s' % (workflow_id))
        try:
            response = self.session.get(url, verify=False).json()
            logging.info('Result: %s' % response)
            return response['result']
        except (requests.HTTPError, requests.ConnectionError) as err:
            msg = 'Could not get blocks results form workflow: %s\n Details: %s' % (workflow_id, err)
            raise NirvanaError(msg)

    def get_target_block_result(self, workflow_id, block_id):
        for block_result in self.get_blocks_results(workflow_id):
            if block_result['blockGuid'] == block_id:
                result = block_result['results']
        return result[0]['storagePath']
