# -*- coding: utf-8 -*-

from sandbox import sdk2
import datetime
import tempfile
import logging
import json

# STANDS_FILE_PATH = '/arcadia/junk/karas-pv/geosearch_acceptance_stands.json'
TIME_FORMAT = '%Y-%m-%dT%H:%M:%S'
MAX_OCC_SECONDS = 24 * 60 * 60
LONG_AGO = '1900-10-26T18:23:26'


class StandError(Exception):
    pass


class Stand(object):

    def __init__(self, name, data):
        self.name = name
        self.occupied = data.get('occupied')
        self.commit = data.get('commit')
        self.acceptance_task = data.get('acceptance_tasks')
        self.lock_time = data.get('lock_time')

    def can_be_unlocked(self):
        if not self.occupied:
            return True
        else:
            now = datetime.datetime.now()
            lock_time = datetime.datetime.strptime(self.lock_time, TIME_FORMAT)
            if now - lock_time > datetime.timedelta(seconds=MAX_OCC_SECONDS):
                return True
        return False

    def lock(self, new_commit, new_acceptance_task):
        self.occupied = True
        self.commit = new_commit
        self.acceptance_task = new_acceptance_task
        now = datetime.datetime.now().strftime(TIME_FORMAT)
        self.lock_time = now

    def unlock(self):
        if self.can_be_unlocked():
            self.occupied = False
            self.commit = 0
            self.acceptance_task = ""
            self.lock_time = LONG_AGO
        else:
            raise StandError('%s can`t be unlocked' % self.name)

    def dump(self):
        return {self.name: {'occupied': self.occupied,
                            'commit': self.commit,
                            'acceptance_tasks': self.acceptance_task,
                            'lock_time': self.lock_time}}


class AcceptanceStands(object):

    def __init__(self, lockfile_svn_path):
        svn_path = sdk2.svn.Arcadia.svn_url(lockfile_svn_path)
        self.lockfile_path = sdk2.svn.Arcadia.checkout(svn_path,
                                                       tempfile.mkdtemp())
        with open(self.lockfile_path) as lock_file:
            self.data = json.load(lock_file)
        self.stands = self.get_stands()

    def get_stands(self):
        return [Stand(name, data) for name, data in self.data.iteritems()]

    def find_free_stand(self, commit, acceptance_task):
        for stand in self.stands:
            if stand.can_be_unlocked():
                stand.lock(commit, acceptance_task)
                return stand
            else:
                logging.info('%s is busy' % stand.name)
                print '%s is busy' % stand.name

    def replace(self, stand):
        self.data.update(stand.dump())
