# -*- coding: utf-8 -*-

import re
import json
import logging
import requests


STOKER_URL = 'https://stoker.z.yandex-team.ru/api/stoker.services.Model'


def _is_upper(host_port):
    url = 'http://{host}/yandsearch?info=getconfig'.format(host=host_port)
    logging.info('Checking {url}'.format(url=url))
    data = requests.get(url).text
    return 'SearchType geo_upper' in data


def get_bolver_config(name, token):
    url = '{stoker_url}/getRecord'.format(stoker_url=STOKER_URL)
    headers = {'Authorization': 'OAuth {token}'.format(token=token)}
    params = {'key': name, 'type': 'TAGGED'}
    data = requests.post(url, data=json.dumps(params), headers=headers).json()
    return data.get('content')


def delete_upper_cgi(name):
    data = get_bolver_config(name)
    rgx = re.compile(r'srcrwr\=GEOV\:(+\.search\.yandex\.net:\d+)\:800')
    instances = []
    for cgi_param in data.get('cgi'):
        instance_match = rgx.findall(cgi_param)
        if instance_match:
            instances.append(instance_match[0])
    upper_instances = [instance for instance in instances if _is_upper(instance)]
    return upper_instances


def set_bolver_config(name, cgi_list, token):
    url = '{stoker_url}/putRecord'.format(stoker_url=STOKER_URL)
    headers = {'Authorization': 'OAuth {token}'.format(token=token)}
    params = {'key': name, 'type': 'TAGGED', 'matcher': {'tag': 'yappy'}}
    params.update({'content': {'cgi': cgi_list}})
    print params
    data = requests.post(url, data=json.dumps(params), headers=headers)
    return data
