# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny

from sandbox.projects.geosuggest import resources


class BuildGeoSuggest(nanny.ReleaseToNannyTask, CommonBuildTask):
    type = 'BUILD_SUGGEST_GEO'

    class InfoField(parameters.SandboxInfoParameter):
        name = 'info_field'
        description = 'Geosuggest'

    class BuildGeoSuggestWebdaemon(parameters.SandboxBoolParameter):
        name = 'build_geo_suggest_webdaemon'
        description = 'geosuggestd'
        default_value = True

    input_parameters = CommonBuildTask.input_parameters + [InfoField, BuildGeoSuggestWebdaemon]
    execution_space = 75 * 1024  # 75 Gb
    disk_space = 75 * 1024  # 75 Gb
    client_tags = ctc.Tag.LINUX_PRECISE

    TARGET_RESOURCE_TYPES = (
        resources.GEO_SUGGEST_WEBDAEMON,
    )

    archs_for_bundle = ('linux', )


__Task__ = BuildGeoSuggest
