# -*- coding: utf-8 -*-

import json
import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.sandboxapi import RELEASE_PRESTABLE

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny

from sandbox.projects.geosuggest import resources


class BuildGeoSuggestViaYaMake(nanny.ReleaseToNannyTask, YaMakeTask):
    type = 'BUILD_SUGGEST_GEO_VIA_YA_MAKE'

    class InfoField(parameters.SandboxInfoParameter):
        name = 'info_field'
        description = 'Geosuggest'

    class BuildGeoSuggestWebdaemon(parameters.SandboxBoolParameter):
        name = 'build_geo_suggest_webdaemon'
        description = 'geosuggestd'
        default_value = True

    input_parameters = YaMakeTask.input_parameters + [InfoField, BuildGeoSuggestWebdaemon]
    execution_space = 75 * 1024  # 75 Gb
    disk_space = 75 * 1024  # 75 Gb
    cores = 24
    client_tags = ctc.Tag.LINUX_PRECISE

    TARGET_RESOURCE_TYPES = (
        resources.GEO_SUGGEST_WEBDAEMON,
    )

    arch = 'linux'
    archs_for_bundle = ('linux', )

    def on_execute(self):
        YaMakeTask.on_execute(self)
        self.create_subtask(
            task_type="RELEASE_ANY",
            inherit_notifications=True,
            input_parameters={"release_task_id": self.id, "release_status": RELEASE_PRESTABLE},
            description="Autorelease of task #{}".format(self.id))

    def on_release(self, additional_parameters):
        self.ctx["nanny_release_info"] = json.dumps(self.get_nanny_release_info(additional_parameters))
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildGeoSuggestViaYaMake
