import os

from sandbox.sandboxsdk.parameters import LastReleasedResource

from sandbox.projects.geosuggest import resources
from sandbox.projects.geosuggest.common.parameters import GeoSuggestDataBuilderParameter
from sandbox.projects.geosuggest.common.tasks import (BuildMapsGeoSuggestWeightInfoBase, AdditionalEnvParameter, )
from sandbox.projects.common.utils import get_or_default


class GeoDictParameter(LastReleasedResource):
    name = 'geo_dict'
    description = 'Suggest dict with geo data'
    resource_type = resources.MAPS_GEO_SUGGEST_GEO_DICT
    requried = True


class BuildMapsGeoSuggestGeoWeightInfo(BuildMapsGeoSuggestWeightInfoBase):

    type = 'BUILD_MAPS_GEO_SUGGEST_GEO_WEIGHT_INFO'
    input_parameters = [GeoSuggestDataBuilderParameter, GeoDictParameter, AdditionalEnvParameter, ]

    def get_dict_resource_id(self):
        return get_or_default(self.ctx, GeoDictParameter)

    def get_script_path(self):
        data_builder_dir = self.sync_resource(
            get_or_default(self.ctx, GeoSuggestDataBuilderParameter)
        )
        script_path = os.path.join(data_builder_dir,
                                   'geo',
                                   'prepare-weight-info.py')
        return script_path

    def get_output_resource_type(self):
        return resources.MAPS_GEO_SUGGEST_GEO_WEIGHT_INFO


__Task__ = BuildMapsGeoSuggestGeoWeightInfo
