from sandbox.projects.geosuggest.resources import MAPS_GEO_SUGGEST_ORG_MERGED_BIN, MAPS_GEO_SUGGEST_ORG_MERGED_TSV
from sandbox.projects.geosuggest.common.utils import get_yt_table_info
from sandbox.projects.geosuggest.common.parameters import WeightsYTTableParameter
from sandbox.projects.geosuggest.common.tasks import BuildMapsGeoSuggestOrgMergedBase


class MainSourceOrgsMergeTaskProperties(object):
    previews = [
        {
            'name': 'Base Weights',
            'parameter': WeightsYTTableParameter,
            'max_rows': 5,
        }
    ]
    yt_path_prefix = "//home/qreg/processing/org_"
    source_type = "BASE"
    output_filename_prefix = ""
    binary_output_resource_type = MAPS_GEO_SUGGEST_ORG_MERGED_BIN
    tsv_output_resource_type = MAPS_GEO_SUGGEST_ORG_MERGED_TSV


class BuildMapsGeoSuggestOrgMergedBin(BuildMapsGeoSuggestOrgMergedBase):
    type = 'BUILD_MAPS_GEO_SUGGEST_ORG_MERGED_BIN'

    TIMEOUT = 9 * 3600

    input_parameters = [
        WeightsYTTableParameter,
    ] + BuildMapsGeoSuggestOrgMergedBase.base_input_parameters

    task_specific_properties = MainSourceOrgsMergeTaskProperties

    def initCtx(self):
        self.ctx['kill_timeout'] = 12 * 60 * 60  # 12 hours

    def get_weights_yt_table_info(self):
        return get_yt_table_info(self.ctx, WeightsYTTableParameter)

    def get_acceptable_country_codes_list(self):
        return []  # Accept all countries


__Task__ = BuildMapsGeoSuggestOrgMergedBin
