import os

from sandbox.sandboxsdk.parameters import LastReleasedResource

from sandbox.projects.geosuggest import resources
from sandbox.projects.geosuggest.common.parameters import GeoSuggestDataBuilderParameter
from sandbox.projects.geosuggest.common.tasks import (BuildMapsGeoSuggestWeightInfoBase, AdditionalEnvParameter, )
from sandbox.projects.common.utils import get_or_default


class OrgDictParameter(LastReleasedResource):
    name = 'org_dict'
    description = 'Suggest dict with org data'
    resource_type = resources.MAPS_GEO_SUGGEST_ORG_DICT
    requried = True


class BuildMapsGeoSuggestOrgWeightInfo(BuildMapsGeoSuggestWeightInfoBase):

    type = 'BUILD_MAPS_GEO_SUGGEST_ORG_WEIGHT_INFO'
    input_parameters = [GeoSuggestDataBuilderParameter, OrgDictParameter, AdditionalEnvParameter, ]

    def get_dict_resource_id(self):
        return get_or_default(self.ctx, OrgDictParameter)

    def get_script_path(self):
        data_builder_dir = self.sync_resource(
            get_or_default(self.ctx, GeoSuggestDataBuilderParameter)
        )
        script_path = os.path.join(data_builder_dir,
                                   'org',
                                   'prepare-weight-info.py')
        return script_path

    def get_output_resource_type(self):
        return resources.MAPS_GEO_SUGGEST_ORG_WEIGHT_INFO


__Task__ = BuildMapsGeoSuggestOrgWeightInfo
