from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.geosuggest.resources import MAPS_GEO_SUGGEST_OSM_ORG_MERGED_BIN, MAPS_GEO_SUGGEST_OSM_ORG_MERGED_TSV
from sandbox.projects.geosuggest.common.utils import get_yt_table_info, get_or_default_with_ctx_update
from sandbox.projects.geosuggest.common.parameters import WeightsOsmYTTableParameter
from sandbox.projects.geosuggest.common.tasks import BuildMapsGeoSuggestOrgMergedBase


class OsmSourceOrgsMergeTaskProperties(object):
    previews = [
        {
            'name': 'OSM Weights',
            'parameter': WeightsOsmYTTableParameter,
            'max_rows': 5,
        }
    ]
    yt_path_prefix = "//home/qreg/processing/osm_org_"
    source_type = "OSM"
    output_filename_prefix = "osm_"
    binary_output_resource_type = MAPS_GEO_SUGGEST_OSM_ORG_MERGED_BIN
    tsv_output_resource_type = MAPS_GEO_SUGGEST_OSM_ORG_MERGED_TSV


class AcceptableCountryCodes(SandboxStringParameter):
    name = 'acceptable_country_codes'
    description = 'Space-separated country codes to use in merged data (leave blank for using all countries)'


class BuildMapsGeoSuggestOsmOrgMergedBin(BuildMapsGeoSuggestOrgMergedBase):
    type = 'BUILD_MAPS_GEO_SUGGEST_OSM_ORG_MERGED_BIN'

    TIMEOUT = 2 * 3600

    input_parameters = [
        WeightsOsmYTTableParameter,
        AcceptableCountryCodes
    ] + BuildMapsGeoSuggestOrgMergedBase.base_input_parameters

    task_specific_properties = OsmSourceOrgsMergeTaskProperties

    def get_weights_yt_table_info(self):
        return get_yt_table_info(self.ctx, WeightsOsmYTTableParameter)

    def get_acceptable_country_codes_list(self):
        codes_str = get_or_default_with_ctx_update(self.ctx, AcceptableCountryCodes)
        return codes_str.split()


__Task__ = BuildMapsGeoSuggestOsmOrgMergedBin
