import os

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import LastReleasedResource
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.geosuggest.common import qp
from sandbox.projects.geosuggest import resources
from sandbox.projects.geosuggest.common.parameters import (GeoSuggestDataBuilderParameter, AdditionalEnvParameter, )
from sandbox.projects.common.utils import get_or_default
from sandbox.projects.masstransit.resources import MASSTRANSIT_DATA_RASP


class MassTransitDataRaspParameter(LastReleasedResource):
    name = 'transport'
    description = 'Public transport routes'
    resource_type = MASSTRANSIT_DATA_RASP
    requried = True


class BuildMapsGeoSuggestTransport(qp.GeoSuggestQPTask):

    type = 'BUILD_MAPS_GEO_SUGGEST_TRANSPORT'
    input_parameters = [GeoSuggestDataBuilderParameter, MassTransitDataRaspParameter, AdditionalEnvParameter, ]

    def on_execute(self):
        AdditionalEnvParameter.ApplyToEnviron(self.ctx)
        data_builder_path = self.sync_resource(
            get_or_default(self.ctx, GeoSuggestDataBuilderParameter)
        )
        transport_builder_path = os.path.join(data_builder_path, 'transport', 'build.py')

        data_rasp_id = get_or_default(self.ctx, MassTransitDataRaspParameter)
        data_rasp_path = self.sync_resource(data_rasp_id)

        out_file = os.path.join(self.abs_path(), 'transport.json')

        run_process(['python', transport_builder_path, data_rasp_path, out_file],
                    outs_to_pipe=True)

        # Sync version with the upstream.
        data_rasp_version = channel.sandbox.get_resource_attribute(data_rasp_id, 'version')

        self.create_resource(
            'Geo suggest transport.json',
            out_file,
            resources.MAPS_GEO_SUGGEST_TRANSPORT,
            attributes={
                MassTransitDataRaspParameter.name: data_rasp_id,
                'version': data_rasp_version,
            },
        )

    @classmethod
    def on_qp_tests(cls, task, rt, prev, curr, env):
        if rt == resources.MAPS_GEO_SUGGEST_TRANSPORT:
            qp.check_file_size_percent(env, prev, curr, 10)


__Task__ = BuildMapsGeoSuggestTransport
