from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects.geosuggest.common.preview import prepare_data_preview, build_preview_footer
from sandbox.projects.geosuggest.common.parameters import (
    WeightsYTTableParameter, SandboxVaultOwner, SandboxVaultYtTokenName
)


class GeoSuggestMakePreview(SandboxTask):
    type = 'GEO_SUGGEST_MAKE_PREVIEW'
    execution_space = 1024
    disk_space = 1024

    input_parameters = [
        WeightsYTTableParameter,
        SandboxVaultOwner,
        SandboxVaultYtTokenName,
    ]

    environment = (
        environments.PipEnvironment('yandex-yt', "0.7.34-0"),
        environments.PipEnvironment("yandex-yt-yson-bindings-skynet"),
    )

    previews = [
        {
            'name': 'Weights',
            'parameter': WeightsYTTableParameter,
            'max_rows': 5,
        }
    ]

    def on_execute(self):
        prepare_data_preview(self, self.previews)
        return

    @property
    def footer(self):
        return build_preview_footer(self, self.previews)


__Task__ = GeoSuggestMakePreview
