import os
import urllib2
from distutils import dir_util
from distutils import file_util

from sandbox.common.types.client import Tag

from sandbox import (
    sandboxsdk,
    sdk2
)
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.environments import VirtualEnvironment
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.geosuggest import resources
from sandbox.projects.geosuggest.common.parameters import (
    GeoSuggestAutotestArguments,
    GeoSuggestDataBuilderParameter,
    GeoSuggestExternalDaemonUrl,
    GeoSuggestPathToAutotest,
    SandboxVaultOwner,
    SandboxVaultYtTokenName
)
from sandbox.projects.common.utils import get_or_default

import sandbox.projects.geosuggest.component as geo_suggest_c


class GeoSuggestTestFunctional(geo_suggest_c.GeoSuggestDaemonTester):

    type = 'GEO_SUGGEST_TEST_FUNCTIONAL'

    required_ram = geo_suggest_c.GeoSuggestDaemonTester.required_ram + 90 * 1024  # +90gb for tests
    GeoSuggestExternalDaemonUrl = GeoSuggestExternalDaemonUrl
    GeoSuggestAutotestArguments = GeoSuggestAutotestArguments
    GeoSuggestPathToAutotest = GeoSuggestPathToAutotest
    GeoSuggestAuxFormulaParameter = geo_suggest_c.GeoSuggestAuxFormulaParameter
    GeoSuggestAuxFormulasParameter = geo_suggest_c.GeoSuggestAuxFormulasParameter
    GeoSuggestAuxExperimentsParameter = geo_suggest_c.GeoSuggestAuxExperimentsParameter
    GeoSuggestCustomFlagsParameter = geo_suggest_c.GeoSuggestCustomFlagsParameter
    GeoSuggestUsePersonalMocksParameter = geo_suggest_c.GeoSuggestUsePersonalMocksParameter

    input_parameters = (
        list(geo_suggest_c.LOAD_TESTING_INPUT_PARAMETERS) +
        [
            GeoSuggestDataBuilderParameter,
            GeoSuggestExternalDaemonUrl,
            GeoSuggestAutotestArguments,
            GeoSuggestPathToAutotest,
            SandboxVaultOwner,
            SandboxVaultYtTokenName,
            GeoSuggestUsePersonalMocksParameter
        ]
    )
    client_tags = Tag.LINUX_PRECISE | Tag.LINUX_TRUSTY

    TIMEOUT = 5 * 3600

    environment = (
        environments.PipEnvironment('yandex-yt', "0.9.9"),
        environments.PipEnvironment("yandex-yt-yson-bindings-skynet"),
    )

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True
        self.ctx['kill_timeout'] = 5 * 3600

    def run_tests(self, daemon_url, data_builder_dir):
        data_builder_tests_dir = os.path.join(data_builder_dir, 'tests')
        autotest_path = os.path.join(data_builder_dir, get_or_default(self.ctx, GeoSuggestPathToAutotest))

        report_path = sandboxsdk.paths.get_unique_file_name(sandboxsdk.paths.get_logs_folder(), 'autotest_report.json')

        additional = get_or_default(self.ctx, GeoSuggestAutotestArguments)

        with VirtualEnvironment(use_system=True) as venv:

            venv.pip('lxml')
            autotest_cmd = [
                autotest_path,
                "--url={0}".format(daemon_url),
                "--props={0}".format(os.path.join(data_builder_tests_dir, 'server.properties')),
                "--report-output={0}".format(report_path),
                "--tests-dir={0}".format(os.path.join(data_builder_dir, 'data')),
            ] + additional.split(" ")

            if autotest_path.endswith(".py"):
                autotest_cmd.insert(0, venv.executable)

            vault_owner = get_or_default(self.ctx, SandboxVaultOwner)
            vault_name = get_or_default(self.ctx, SandboxVaultYtTokenName)

            env = dict(
                os.environ,
                MR_RUNTIME="YT",
                YT_PREFIX="//",
                YT_TOKEN=self.get_vault_data(vault_owner, vault_name),
                WIKI_TOKEN=self.get_vault_data(vault_owner, vault_name),
            )

            run_process(
                autotest_cmd,
                wait=True,
                log_prefix='autotest',
                environment=env,
            )

        export_dir = os.path.join(self.abs_path(), 'test_functional_report')
        dir_util.mkpath(export_dir)
        file_util.copy_file(report_path, os.path.join(export_dir, 'autotest_report.json'))
        self.create_resource(
            'Geosuggest quality test report',
            export_dir,
            resources.GEO_SUGGEST_TEST_FUNCTIONAL_REPORT,
        )

    def on_execute(self):
        daemon_url = get_or_default(self.ctx, GeoSuggestExternalDaemonUrl)
        data_builder_dir = self.sync_resource(get_or_default(self.ctx, GeoSuggestDataBuilderParameter))

        if daemon_url == "":
            personal_data_mocks_dir = None
            if get_or_default(self.ctx, geo_suggest_c.GeoSuggestUsePersonalMocksParameter):
                personal_data_mocks_dir = sdk2.Path(data_builder_dir) / 'data' / 'personal_data_mocks'

            with self.start_daemon(personal_data_mocks_dir=personal_data_mocks_dir) as geosuggestd:
                self.run_tests(
                    daemon_url="http://localhost:{0}/suggest-geo".format(geosuggestd.port),
                    data_builder_dir=data_builder_dir)
        else:
            self.run_tests(
                daemon_url=daemon_url,
                data_builder_dir=data_builder_dir)

    def download_content(self, resource, filename):
        url = resource.proxy_url + "/" + filename
        try:
            response = urllib2.urlopen(url)
            return response.read()
        except urllib2.HTTPError, e:
            if e.code == 404:
                return '<a href="{0}">{1}</a> is empty or does not exist'.format(url, filename)

    @property
    def footer(self):
        if not self.is_finished():
            return "<p>Results are not ready yet</p>"

        task_logs_resources = self.list_resources("TASK_LOGS")
        if not task_logs_resources:
            return "<p>No TASK_LOGS resource, can't render proper footer</p>"

        return '<p><b>stdout:</b><br/><pre>{0}</pre><b>stderr:</b><br/><pre>{1}</pre></p>'.format(
            self.download_content(task_logs_resources[0], "autotest.out.txt"),
            self.download_content(task_logs_resources[0], "autotest.err.txt"))


__Task__ = GeoSuggestTestFunctional
