import sandbox.projects.geosuggest.component as geo_suggest_c
import sandbox.projects.common.search.performance
import sandbox.projects.common.utils
import sandbox.projects.geosuggest.GeoSuggestTestPerformance
import sandbox.sandboxsdk.task as sdk_task
import sandbox.common.types.task as ctt
import sandbox.common.types.client as ctc

from sandbox.sandboxsdk.channel import channel

_GEO_SUGGEST_TEST_PERFORMANCE_SUBTASK_IDS = 'geosuggest_test_performance_subtask_ids'


class GeoSuggestTestPerformanceBest(
    sandbox.projects.common.search.performance.OldShootingTask,
    sdk_task.SandboxTask
):

    type = 'GEO_SUGGEST_TEST_PERFORMANCE_BEST'
    client_tags = (
        (ctc.Tag.GENERIC
         | ctc.Tag.LXC)
        & ctc.Tag.LINUX_PRECISE
    )
    execution_space = 2024  # 2 Gb
    required_ram = 2024  # 2 Gb

    SE_TAGS = {
        geo_suggest_c.SE_TAG_I_AM_ROBOT: 10,
    }

    input_parameters = (
        [geo_suggest_c.GeoSuggestNumberOfPerformanceSubtasks, ]
        + list(geo_suggest_c.LOAD_TESTING_INPUT_PARAMETERS)
        + [geo_suggest_c.GeoSuggestDolbilkaPlanParameter, ]
        + list(sandbox.projects.common.search.performance.OldShootingTask.shoot_input_parameters)
    )

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True

        self.ctx['enable_lunapark'] = True
        self.ctx['tank_task_name'] = 'QREG-188'

    def _spawn_geosuggest_test_performance_subtask(self):
        ctx = dict()
        geo_suggest_c.copy_context_params(
            from_ctx=self.ctx,
            to_ctx=ctx,
            param_types=sandbox.projects.common.search.performance.OldShootingTask.shoot_input_parameters,
        )
        geo_suggest_c.copy_context_params(
            from_ctx=self.ctx,
            to_ctx=ctx,
            param_types=list(geo_suggest_c.LOAD_TESTING_INPUT_PARAMETERS) + [geo_suggest_c.GeoSuggestDolbilkaPlanParameter, ],
        )
        geo_suggest_c.disable_notifications(ctx)
        s = self.create_subtask(
            task_type=sandbox.projects.geosuggest.GeoSuggestTestPerformance.GeoSuggestTestPerformance.type,
            description='Test geo suggest performance',
            se_tag=self.se_tag,
            input_parameters=ctx,
        )

        self.ctx[_GEO_SUGGEST_TEST_PERFORMANCE_SUBTASK_IDS].append(s.id)

    def on_enqueue(self):
        sdk_task.SandboxTask.on_enqueue(self)
        if self.se_tag:
            sem_name = "{}/{}".format(self.type, self.se_tag)
            self.semaphores(ctt.Semaphores(
                acquires=[
                    ctt.Semaphores.Acquire(name=sem_name, capacity=self.SE_TAGS[self.se_tag])
                ]
            ))

    def on_execute(self):
        with self.memoize_stage.spawn_performance_subtasks:
            self.ctx[_GEO_SUGGEST_TEST_PERFORMANCE_SUBTASK_IDS] = []
            for _ in range(self.ctx[geo_suggest_c.GEO_SUGGEST_TEST_PERFORMANCE_SUBTASKS_COUNT_CTX_KEY]):
                self._spawn_geosuggest_test_performance_subtask()

        with self.memoize_stage.wait_performance_subtasks:
            sandbox.projects.common.utils.wait_all_subtasks_stop()

        sandbox.projects.common.utils.check_subtasks_fails(
            custom_subtasks=self.ctx[_GEO_SUGGEST_TEST_PERFORMANCE_SUBTASK_IDS],
        )

        for perf_subtask_id in self.ctx[_GEO_SUGGEST_TEST_PERFORMANCE_SUBTASK_IDS]:
            perf_t = channel.sandbox.get_task(perf_subtask_id)
            assert perf_t is not None
            geo_suggest_c.aggregate_dolbilka_ctx_fields(self.ctx, perf_t.ctx)

        self._init_virtualenv()  # for footer?
