# -*- coding: utf-8 -*
import os
import shutil

from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.common.geosearch.base_update import generate_base_update_task_sdk2
from sandbox.projects.geosuggest.BuildGeosuggestIndex import BuildGeosuggestIndex


UpdateTask = generate_base_update_task_sdk2(BuildGeosuggestIndex,
                                            release_subject='Build geosuggest index')


class UpdateGeosuggestIndex(UpdateTask):
    '''
        Update input resources for geosuggest index build
    '''
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

        environments = (environments.PipEnvironment('yandex-yt', use_wheel=True),)

        class Caches(sdk2.Requirements.Caches):
            pass

    def save_resource(self, resource_type, resource_attrs):
        existing_resource = sdk2.Resource[resource_type].find(attrs=resource_attrs).first()
        existing_data_path = sdk2.ResourceData(existing_resource).path
        new_data_path = os.path.join(str(self.path()),
                                     os.path.basename(str(existing_data_path)))
        shutil.copytree(str(existing_data_path), new_data_path)
        resource_class = sdk2.Resource[resource_type]
        new_resource = resource_class(self,
                                      'Saved resource #{existing} for build time'.format(existing=existing_resource.id),
                                      new_data_path,
                                      saved_for_geosuggest_index=1,
                                      ttl=7)
        new_resource_data = sdk2.ResourceData(new_resource)
        new_resource_data.ready()

    def on_prepare(self):
        sdk2.Task.on_prepare(self)
        self.save_resource('MASSTRANSIT_DATA_RASP', resource_attrs={'released': 'stable', 'garden_environment': 'production'})

    def _setup_yt_client(self, yt_client):
        yt_client.config['token'] = sdk2.Vault.data('GEO_SUGGEST', 'yt_token')
        yt_client.config['proxy']['url'] = 'hahn.yt.yandex.net'
        return True
