import os
import re

from sandbox.sandboxsdk.parameters import LastReleasedResource
from sandbox.sandboxsdk.paths import copy_path, make_folder
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.geosuggest.resources import MAPS_GEO_SUGGEST_ORG_MERGED_BIN
from sandbox.projects.geosuggest.common.tasks import UpdateMapsGeoSuggestSaasIndex
from sandbox.projects.geosuggest.common.parameters import (
    BackaExportParameter, GeoSuggestDataBuilderParameter,
)
from sandbox.projects.common.geosearch.utils import unpack_file
from sandbox.projects.common.utils import get_or_default


class MergedOrgsParameter(LastReleasedResource):
    name = 'merged_orgs'
    description = 'Merged organizations (org_<lang>.tsv)'
    required = True
    resource_type = MAPS_GEO_SUGGEST_ORG_MERGED_BIN


class UpdateMapsGeoSuggestSaasOrgs(UpdateMapsGeoSuggestSaasIndex):
    """
    Reindex organizations.
    """

    type = 'UPDATE_MAPS_GEO_SUGGEST_SAAS_ORGS'
    input_parameters = UpdateMapsGeoSuggestSaasIndex.base_input_parameters + [
        GeoSuggestDataBuilderParameter,
        BackaExportParameter,
        MergedOrgsParameter,
    ]

    @property
    def common_proxy_source_type(self):
        return 'SUGGEST_TSV'

    @property
    def common_proxy_processor_type(self):
        return 'ORG_TO_SUGGEST'

    def prepare_common_proxy_config_context(self, indexer_host):
        context = UpdateMapsGeoSuggestSaasIndex.prepare_common_proxy_config_context(
            self, indexer_host,
        )

        data_builder_path = self.sync_resource(
            get_or_default(self.ctx, GeoSuggestDataBuilderParameter),
        )
        aliases_path = os.path.join(data_builder_path, 'org', 'data', 'aliases.txt')

        backa_export_path = self.sync_resource(
            get_or_default(self.ctx, BackaExportParameter),
        )
        backa_export_dir = os.path.join(self.abs_path(), 'backa')
        make_folder(backa_export_dir)
        unpack_file(backa_export_path, backa_export_dir)
        companies2_xml_path = os.path.join(backa_export_dir, 'companies2.xml.gz')

        merged_orgs_path = self.sync_resource(self.ctx[MergedOrgsParameter.name])

        # aliases_path and companies2_xml_path should be added to input_files_section.
        print aliases_path
        print companies2_xml_path

        input_files_section = []

        for filename_gz in os.listdir(merged_orgs_path):
            match = re.match(r'^org.(\w+).tsv.gz$', filename_gz)
            if not match:
                continue

            language = match.group(1)

            source_path_gz = os.path.join(merged_orgs_path, filename_gz)
            local_path_gz = self.path(filename_gz)
            copy_path(source_path_gz, local_path_gz)
            run_process(['gunzip', local_path_gz])
            path = re.sub(r'.gz$', '', local_path_gz)

            input_file_section = COMMON_PROXY_INPUT_FILE_TEMPLATE.format(
                language=language,
                path=path,
            )
            input_files_section.append(input_file_section)

        assert input_files_section
        input_files_section = ''.join(input_files_section)

        context['input_files_section'] = input_files_section

        return context


COMMON_PROXY_INPUT_FILE_TEMPLATE = '''\
            <InputFile>
                Language: {language}
                Path: {path}
            </InputFile>
'''


__Task__ = UpdateMapsGeoSuggestSaasOrgs
