import os

from sandbox.sandboxsdk.parameters import LastReleasedResource
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.geosuggest import resources
from sandbox.projects.common.geosearch.utils import unpack_file
from sandbox.projects.geosuggest.common.tasks import UpdateMapsGeoSuggestSaasIndex
from sandbox.projects.geobase.Geodata5BinStable import resource as gbr


class ToponymsParameter(LastReleasedResource):
    name = 'toponyms'
    description = 'Toponyms'
    required = True
    resource_type = resources.MAPS_GEO_SUGGEST_GEO_OBJECTS_WEIGHT


class GeoBaseParameter(LastReleasedResource):
    name = 'geobase5bin'
    description = 'geobase5.bin'
    required = True
    resource_type = gbr.GEODATA5BIN_STABLE


class UpdateMapsGeoSuggestSaasToponyms(UpdateMapsGeoSuggestSaasIndex):
    """
    Reindex toponyms.
    """

    type = 'UPDATE_MAPS_GEO_SUGGEST_SAAS_TOPONYMS'
    input_parameters = UpdateMapsGeoSuggestSaasIndex.base_input_parameters + [ToponymsParameter, GeoBaseParameter]

    MAPS_DATA_ARCADIA_PATH = ('arcadia:/arc/trunk/arcadia'
                              '/quality/trailer/suggest/services'
                              '/maps/scripts/maps-data-builder/maps-data')

    @property
    def common_proxy_source_type(self):
        return 'GEO_SUGGEST_TOPONYMS_XML_READER'

    @property
    def common_proxy_processor_type(self):
        return 'TOPONYM_TO_SUGGEST'

    def fetch_data_from_arcadia(self, svn_url, path):
        Arcadia.export(svn_url, path)

    def prepare_common_proxy_config_context(self, indexer_host):
        context = UpdateMapsGeoSuggestSaasIndex.prepare_common_proxy_config_context(
            self, indexer_host,
        )

        maps_data_dir = self.abs_path('maps_data')
        self.fetch_data_from_arcadia(self.MAPS_DATA_ARCADIA_PATH, maps_data_dir)
        aliases_txt_path = os.path.join(maps_data_dir, 'aliases.txt')
        replace_table_xml_path = os.path.join(maps_data_dir, 'replace-table.xml')
        short_path_txt_path = os.path.join(maps_data_dir, 'short-path.txt')

        toponyms_xml_gz_path = self.sync_resource(self.ctx[ToponymsParameter.name])
        toponyms_dir = self.abs_path('toponyms')
        make_folder(toponyms_dir)
        toponyms_filename = 'toponyms.xml'
        toponyms_xml_path = os.path.join(toponyms_dir, toponyms_filename)
        unpack_file(toponyms_xml_gz_path, toponyms_dir, to_name=toponyms_filename)
        geobase_bin_path = self.sync_resource(self.ctx[GeoBaseParameter.name])

        context['input_files_section'] = '''
            File: {}
            GeoBasePath: {}
        '''.format(toponyms_xml_path, geobase_bin_path)
        context['processor_extra'] = '''
            FullpathReplacer: {}
            LetterMap: {}
            Aliases: {}
        '''.format(short_path_txt_path, replace_table_xml_path, aliases_txt_path)

        return context


__Task__ = UpdateMapsGeoSuggestSaasToponyms
