# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.projects.geosuggest import resources as gsr
from sandbox.projects.masstransit.resources import MASSTRANSIT_DATA_RASP


class UpdateMapsGeoSuggestTransport(sdk2.Task):
    """
        Run and release BUILD_MAPS_GEO_SUGGEST_TRANSPORT
    """
    class Parameters(sdk2.Task.Parameters):
        data_builder = sdk2.parameters.Resource(
            'Geo suggest data builder executable files',
            resource_type=gsr.MAPS_GEO_SUGGEST_DATA_BUILDER,
            required=True
        )

    def on_execute(self):
        if self.Context.subtasks:
            subtasks = list(self.find(id=self.Context.subtasks).limit(len(self.Context.subtasks)))
        else:
            subtasks = None
        if not subtasks:
            subtasks = []

            masstransit_data = sdk2.Resource[MASSTRANSIT_DATA_RASP].find(attrs={'released': 'stable'}).first()

            build_task_class = sdk2.Task["BUILD_MAPS_GEO_SUGGEST_TRANSPORT"]
            subtask = build_task_class(self,
                                       description="Build geo suggest transport json",
                                       create_sub_task=False,
                                       data_builder=self.Parameters.data_builder,
                                       transport=masstransit_data)

            subtask.save()
            subtasks.append(subtask.enqueue())

            if subtasks:
                self.Context.subtasks = map(lambda _: _.id, subtasks)

            raise sdk2.WaitTask(subtasks,
                                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                                wait_all=True)
        else:
            self.server.release(task_id=self.Context.subtasks[0], type=ctt.ReleaseStatus.STABLE, subject="Release geo suggest transport json")
