import os

from sandbox.sandboxsdk.process import run_process


class GeoSuggestPortablePyPyInstaller():
    def __init__(self):
        self.pypy_root_path = None
        self.venv_path = None
        self.venv_bin_path = None

    def install(self, task, resource_id):
        # Download and unpack portable resource
        pypy_packed_path = task.sync_resource(resource_id)
        pypy_root_path = task.path('pypy')
        run_process(['mkdir', pypy_root_path])
        run_process(['tar', '-xf', pypy_packed_path, '-C', pypy_root_path, '--strip-components', '1'])
        # Create virtual env directory
        python_bin_path = os.path.join(pypy_root_path, 'bin')
        virtualenv_bin = os.path.join(python_bin_path, 'virtualenv-pypy')
        venv_path = task.path('pypy_virtual_env')
        run_process([virtualenv_bin, '--no-site-packages', '--always-copy', venv_path])
        # Save paths
        self.pypy_root_path = pypy_root_path
        self.venv_path = venv_path
        self.venv_bin_path = os.path.join(venv_path, 'bin')

    def pip(self, package_name):
        pip_path = os.path.join(self.venv_bin_path, 'pip')
        run_process([pip_path, 'install', package_name])

    # Returns list of strings to pass in run_command
    def get_cmd(self, args):
        return [os.path.join(self.venv_bin_path, 'pypy')] + args
