# -*- coding: UTF-8 -*-

import smtplib

from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText


class EmailBuilder(object):
    def __init__(self):
        self.text = ''
        self.html = '<html><head><meta charset="UTF-8"/></head>\n<body>\n'

    def add_paragraph(self, p):
        self.text += p + '\n'
        self.html += '{0}<br/>\n'.format(p)

    def add_link(self, link, name='', comment=''):
        self.text += link + '\n'
        self.html += '<a href="{0}">{1}</a>{2}<br/>\n'.format(
            link,
            name if name else link,
            ' ({})'.format(comment) if comment else ''
        )

    def add_table(self, column_names, rows):
        def to_string(value):
            if isinstance(value, float):
                if value < 1.0e-6:
                    return '{:.2}'.format(value)
                if value < 1.0:
                    return '{:.6f}'.format(value)
                if value < 100.0:
                    return '{:.2f}'.format(value)
                return '{:.1f}'.format(value)
            return '{}'.format(value)
        self.html += '<table border="0">\n'
        self.html += '<tr>\n'
        for name in column_names:
            self.html += '<th align="left">{}</th>'.format(name)
        self.html += '</tr>\n'
        for row in rows:
            self.html += '<tr>\n'
            for value in row:
                self.html += '<td align="left">{}</td>'.format(to_string(value))
            self.html += '</tr>\n'
        self.html += '</table>\n'
        self.html += '<br/>\n'

    def add_space(self):
        self.text += '\n'
        self.html += '<br/>\n'

    def add_signature(self):
        self.add_paragraph('--')
        self.add_paragraph('Макаронный Монстр')

    def get_text(self):
        return self.text

    def get_html(self):
        return self.html + '</body></html>\n'

    def get_multipart(self, subject, from_, to):
        msg = MIMEMultipart('alternative')
        msg['Subject'] = subject
        msg['From'] = from_
        msg['To'] = to
        msg.attach(MIMEText(self.get_text(), 'plain', 'utf-8'))
        msg.attach(MIMEText(self.get_html(), 'html', 'utf-8'))
        return msg.as_string()


def send_email_multipart(report, subject, from_, to, body):
    # TODO retries
    multipart = report.get_multipart(subject, "noreplay@sandbox.yandex.ru", to)
    srv = smtplib.SMTP('localhost')
    srv.sendmail(from_, to.split(','), multipart)
    srv.quit()
