import urllib


class QueryParameters(object):
    def __init__(self, qs):
        self._items = qs.split('&')

    def upsert(self, key, value):
        new_kv = QueryParameters.compose_kv(key, value)
        replaced = False

        for i, kv in enumerate(self._items):
            if QueryParameters.check_key(kv, key):
                self._items[i] = new_kv
                replaced = True
        if not replaced:
            self._items.append(new_kv)

    def erase(self, key):
        self._items = [kv for kv in self._items if not QueryParameters.check_key(kv, key)]

    def append(self, key, value):
        self._items.append(QueryParameters.compose_kv(key, value))

    def join(self):
        return '&'.join(self._items)

    @staticmethod
    def check_key(kv, key):
        return kv.startswith(key) and ((kv == key) or kv[len(key)] == '=')

    @staticmethod
    def compose_kv(key, value):
        return '{}={}'.format(key, urllib.quote(value))


def _process_url(url, action):
    if not isinstance(url, str):
        raise ValueError('URL in UTF-8 is expected')
    path, query_string = url.split('?', 1)
    params = QueryParameters(query_string)
    action(params)
    return path + '?' + params.join()


def stabilize(url, override_parameters=''):
    def action(params):
        params.upsert('timeout', '1000000000')
        if override_parameters:
            for kv in override_parameters.split('&'):
                k, v = kv.split('=', 1)
                params.upsert(k, v)

    return _process_url(url, action)


def set_experiments(url, new_experiments):
    def action(params):
        for param in ('exprt', 'custom_ranking'):
            params.erase(param)
            params.erase('experimental_{}'.format(param))

        if len(new_experiments) > 0:
            params.append('exprt', ','.join(str(e) for e in new_experiments))

    return _process_url(url, action)
