# coding: utf-8

"""
    Resource types.

    See :class:`AbstractResource` for description of class parameters.

    NOTE: Please don't delete or rename existing resource classes.
    Questions? Suggestions? Ask on sandbox@yandex-team.ru maillist!

    Please obey Sandbox https://wiki.yandex-team.ru/sandbox/codestyleguide
    Especially, leave exactly 2 lines between class declarations!
"""
from __future__ import absolute_import

from sandbox import sdk2

geosuggest_releasers = [
    'GEO_SUGGEST'
]

AbstractResource = sdk2.resource.AbstractResource


class GEO_SUGGEST_WEBDAEMON(AbstractResource):
    """
        Исполняемый файл для саджеста Карт.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/services/maps/SuggestFcgiD/geosuggestd'


class GEO_SUGGEST_DATA(AbstractResource):
    """
        GeoSuggest daemon data.
    """
    releasable = True
    auto_backup = True
    releasers = release_subscribers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/services/maps/data/package'


class GEO_SUGGEST_MATRIXNET_MODEL(AbstractResource):
    """
        GeoSuggest ranking formula.
    """


class GEO_SUGGEST_STATIC_DATA(AbstractResource):
    """
        GeoSuggest daemon static data (format is identical to GEO_SUGGEST_DATA).
    """
    releasable = True
    auto_backup = True
    releasers = release_subscribers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/services/maps/data/package'


class GEO_SUGGEST_WEBDAEMON_PLAN(AbstractResource):
    """
        GeoSuggest plan for d-executor.
    """
    auto_backup = True
    use_for_acceptance = sdk2.Attributes.Bool('Use the plan in geosuggest acceptance task')


class GEO_SUGGEST_WEBDAEMON_CONFIG(AbstractResource):
    """
        GeoSuggest daemon config.
    """
    auto_backup = True


class GEO_SUGGEST_RTYSERVER_CONFIG(AbstractResource):
    """
        Config for rtyserver
    """
    auto_backup = True


class GEO_SUGGEST_TOOLBOX_EXECUTABLE(AbstractResource):
    """
        GeoSuggest binary utils.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/services/maps/tools/toolbox/geosuggest-toolbox'


class GEO_SUGGEST_TEST_FUNCTIONAL_REPORT(AbstractResource):
    """
        GeoSuggest report from functional test
    """
    releasable = True
    auto_backup = True
    releasers = geosuggest_releasers


class GEO_SUGGEST_TEST_FUNCTIONAL_DIFF_REPORT(AbstractResource):
    """
        GeoSuggest report from functional test
    """
    releasable = True
    auto_backup = True
    releasers = geosuggest_releasers


class GEO_SUGGEST_PRIEMKA_REPORT(AbstractResource):
    """
        GeoSuggest report from priemka task GEO_SUGGEST_PRIEMKA.
    """
    releasable = True
    auto_backup = True
    releasers = geosuggest_releasers


class GEO_SUGGEST_QP_REPORT(AbstractResource):
    """
        GeoSuggest report after qp tests (see common/geosuggest/qp.py).
    """
    releasable = True
    auto_backup = True
    releasers = geosuggest_releasers


class GEO_SUGGEST_DATA_BEFORE_POSTPROCESSING(AbstractResource):
    """
        GeoSuggest daemon data before postprocessing (binary toponyms etc).
    """
    releasable = True
    auto_backup = True
    releasers = release_subscribers = geosuggest_releasers


class GEO_SUGGEST_ORG_BUILDER(AbstractResource):
    """
        executable from quality/trailer/suggest/services/maps/tools/org_builder
    """
    releasable = True
    releasers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/services/maps/tools/org_builder'


class GEO_SUGGEST_SANDBOX_BIN(AbstractResource):
    """
        executable for geosuggest building processes
    """
    releasable = True
    releasers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/services/maps/build/sandbox-bin'


class GEO_SUGGEST_PERSONAL_WEBDAEMON(AbstractResource):
    """
        geosuggest-personald
    """
    releasable = True
    releasers = geosuggest_releasers
    arcadia_build_path = 'geosuggest/daemons/personald'


class MAPS_GEO_SUGGEST_PREPARE_TOPONYMS_BIN(AbstractResource):
    """
        prepare_toponyms_bin
    """
    releasable = True
    releasers = release_subscribers = geosuggest_releasers


class MAPS_GEO_SUGGEST_WEBSUGGEST_CONFIGS(AbstractResource):
    """
        unitstable.conf and unitstable-tr.conf
    """
    releasable = True
    releasers = release_subscribers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/web_fastcgidaemon/websuggest-configs'


class SUGGEST_DATA_BUILDER(AbstractResource):
    """
        executable from quality/trailer/suggest/data_builder
    """
    releasable = True
    releasers = geosuggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/data_builder/suggest-data-builder'


class MAPS_GEO_SUGGEST_BASE_RESOURCE(AbstractResource):
    """
        Base data resource class for internal use
    """
    releasable = True
    releasers = release_subscribers = geosuggest_releasers


class MAPS_GEO_SUGGEST_STABLE_RESOURCE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Base class for resources that should be used only if released
    """


class MAPS_GEO_SUGGEST_DATA_BUILDER(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Executables to build geo suggest export
    """
    releasable = True
    releasers = release_subscribers = geosuggest_releasers


class MAPS_GEO_SUGGEST_GEO_DICT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Geo suggest geo dict
    """


class MAPS_GEO_SUGGEST_ORG_DICT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Geo suggest organizations dict
    """


class MAPS_GEO_SUGGEST_COUNTRIES(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        A list of countries to fetch toponyms for
    """


class MAPS_GEO_SUGGEST_TRANSPORT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Transport data json derived from MASSTRANSIT_DATA_RASP
    """
    auto_backup = True


class MAPS_GEO_SUGGEST_GEO_WEIGHT_INFO(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Toponyms weights info in text format
    """


class MAPS_GEO_SUGGEST_ORG_WEIGHT_INFO(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Processed suggest-dicts/geo.suggest.{timestamp}/org.*
    """


class MAPS_GEO_SUGGEST_POI(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Poi export for geosuggest (poi.xml.gz in backa-like format)
    """


class MAPS_GEO_SUGGEST_GEOCODER_EXPORT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Geocoder export squashed from multiple viewpoints
    """


class MAPS_GEO_SUGGEST_GEO_OBJECTS_WEIGHT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        The resulting map.objects.weight.xml
    """
    auto_backup = True


class MAPS_GEO_SUGGEST_ORG_MERGED_TXT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Merged log stats and backa export in text format.
    """


class MAPS_GEO_SUGGEST_ORG_MERGED_READY(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        ready input for binary dictionary
    """


class MAPS_GEO_SUGGEST_ORG_MERGED_PRETTY(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        pretty input for binary dictionary
    """


class MAPS_GEO_SUGGEST_ORG_MERGED_STREAMS(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        streams input for binary dictionary
    """


class MAPS_GEO_SUGGEST_ORG_MERGED_GROUPS(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        groups input for binary dictionary
    """


class MAPS_GEO_SUGGEST_BACKA_IDS_TRIE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        All ids from BACKA packed in trie
    """


class MAPS_GEO_SUGGEST_GEOCODE_CACHE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Cached info for backa companies
    """


class MAPS_GEO_SUGGEST_ORG_2_ADDR(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        oid2addr.tsv
    """
    auto_backup = True


class MAPS_GEO_SUGGEST_ORG_2_ADDR_NOT_JOINED(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        companies2.not_joined (temporary file at org2addr stage)
    """


class MAPS_GEO_SUGGEST_ORG_2_ADDR_PARSED_COMPANIES(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        companies2.parsed (temporary file at org2addr stage)
    """


class MAPS_GEO_SUGGEST_MISSPELLS(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Misspells tries
    """


class MAPS_GEO_SUGGEST_CLICKTOPS(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        clicktops.txt
    """


class MAPS_GEO_SUGGEST_QUERY_TXT(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        query.txt
    """


class MAPS_GEO_SUGGEST_WEIGHTS_DUMP(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        weights.txt dump from YT
    """


class MAPS_GEO_SUGGEST_PREPARED_WEIGHTS_DUMP(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        prepared_weights.txt dump from YT
    """


class MAPS_GEO_SUGGEST_COMMON_PROXY_CONFIG_TEMPLATE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Common proxy config
    """


class MAPS_GEO_SUGGEST_WEIGHTS_YT_TABLE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Name of YT table with weights
    """


class MAPS_GEO_SUGGEST_WEIGHTS_OSM_YT_TABLE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Name of YT table with weights of OSM objects
    """


class MAPS_GEO_SUGGEST_TRAINING_POOL_YT_TABLE(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Name of YT table with training data and other training parameters
    """


class MAPS_GEO_SUGGEST_DATA_PREVIEW(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Preview for input and output data
    """


class MAPS_GEO_SUGGEST_GEO_SEARCH_HISTORY_TSV(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        geo_search_dictionary builder input (user-friendly tsv)
    """


class MAPS_GEO_SUGGEST_GEO_SEARCH_HISTORY_BIN(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        geo_search_dictionary/bin
    """


class MAPS_GEO_SUGGEST_GEO_SEARCH_NGRAMS_TSV(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        geo_search ngrams (user-friendly tsv)
    """


class MAPS_GEO_SUGGEST_GEO_SEARCH_NGRAMS_BIN(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        geo_search ngrams (compiled trie)
    """


class MAPS_GEO_SUGGEST_ORG_MERGED_BIN(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Merged organizations info in binary format.
    """
    auto_backup = True


class MAPS_GEO_SUGGEST_ORG_MERGED_TSV(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Merged organizations info in text format
    """


class MAPS_GEO_SUGGEST_OSM_ORG_MERGED_BIN(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Merged OSM organizations info in binary format.
    """
    auto_backup = True


class MAPS_GEO_SUGGEST_OSM_ORG_MERGED_TSV(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Merged OSM organizations info in text format
    """


class MAPS_GEO_SUGGEST_GEO_GLOBAL_FACTORS(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Geo objects global factors data in text format
    """


class MAPS_GEO_SUGGEST_RANKING_POOL(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        Geo suggest pool intended for FML evaluation
    """


class GEO_SUGGEST_SEARCH_GROUPS_BUILDER(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        binary for indexing searchgroups
    """


class MAPS_GEO_SUGGEST_SEARCH_GROUPS(MAPS_GEO_SUGGEST_BASE_RESOURCE):
    """
        search groups index
    """
    auto_backup = True


class GeoSuggestJsonResponses(sdk2.Resource):
    """
        Geosuggest responses converted to JSON, one per line.
    """


class MAPS_GEO_SUGGEST_PREFIXTOPS_MYAK(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Geosuggest prefixtops for MYAK
    """


class MAPS_GEO_SUGGEST_PREFIXTOPS_MYAK_NGRAM(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Geosuggest ngram prefixtops for MYAK
    """


class MAPS_GEO_SUGGEST_PREFIXTOPS_BYAK(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Main geosuggest prefixtop
    """


class MAPS_GEO_SUGGEST_PREFIXTOPS_NAVI(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Navi geosuggest prefixtop
    """


class MAPS_GEO_SUGGEST_PREFIXTOPS_TAXI(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Taxi geosuggest prefixtop
    """


class MAPS_GEO_SUGGEST_PREFIXTOPS_TAXI_WORLD(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
    Taxi prefixtop for new countries
    """


class GEO_SUGGEST_PREFIXTOPS(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Geosuggest prefixtops
    """


class GEO_SUGGEST_TOP_RUBRICS_BY_REGIONS_TSV(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        top_rubrics_by_regions.tsv
    """
    releasers = geosuggest_releasers + ['MAPS_FRONT']


class GEO_SUGGEST_TOP_RUBRICS_CONFIG_JSON(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        top_rubrics_config.json
    """
    releasers = geosuggest_releasers + ['MAPS_FRONT']


class GEO_SUGGEST_FOREIGN_TRIE(MAPS_GEO_SUGGEST_STABLE_RESOURCE):
    """
        Geosuggest foreign trie
    """
