import sys
import logging

from sandbox import common
from sandbox import sdk2


class GlycineResource(sdk2.Resource):
    pass


class Glycine(sdk2.Task):
    class Parameters(sdk2.Parameters):
        block_spec = sdk2.parameters.JSON("block_spec")

        with sdk2.parameters.Output():
            outputs = sdk2.parameters.JSON("outputs")

    class Requirements(sdk2.Requirements):

        # this emits requirements/caches == {} leading to execution on multislot allowed
        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        ret = self.run(self.Parameters.block_spec)
        self.Parameters.outputs = ret

    def run(self, block_spec):
        import glycine.api as gly
        from glycine.sdk import sb

        sb.owner = self.owner

        block = gly.from_spec(block_spec)

        logging.info('Run block %s', str(block))

        try:
            result = gly.JobResult(result=block.execute())
        except (common.errors.Wait, common.errors.NothingToWait, sdk2.Wait):
            raise
        except Exception:
            result = gly.JobResult(error=gly.ExcInfo(*sys.exc_info()))

        return gly.to_spec(result)
