import base64

from sandbox import sdk2


class Glycine2(sdk2.Task):
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.String("Format") as proto_format:
            proto_format.values.binary = proto_format.Value("Binary", default=True)
            proto_format.values.json = "JSON"

        request = sdk2.parameters.String("Request", multiline=True, required=True)

        with sdk2.parameters.Output():
            response = sdk2.parameters.String("Response", multiline=True, required=True)

    def on_execute(self):
        from google.protobuf import json_format

        from tasklet.api import tasklet_pb2
        from tasklet.runtime import dispatch

        if self.Parameters.proto_format == "json":
            request = tasklet_pb2.JobInstance()
            json_format.Parse(self.Parameters.request, request)
            request_data = request.SerializeToString()
        else:
            request_data = base64.b64decode(self.Parameters.request)

        response_data = dispatch.dispatch(request_data)

        if self.Parameters.proto_format == "json":
            response = tasklet_pb2.JobResult()
            response.ParseFromString(response_data)
            self.Parameters.response = json_format.MessageToJson(response)
        else:
            self.Parameters.response = base64.b64encode(response_data)
