from sandbox import sdk2
from sandbox.projects.yappy.tasks.CreateYappyBeta import CreateYappyBeta, LOGGER, YappyBetaCreationTimeoutError

import sys
import time
import random

import six
import requests
# from retrying import retry


# time in msec
# contrib/python/retrying is not available in sandbox venv
def retry(stop_max_attempt_number, wait_random_min, wait_random_max):
    def decorator(decoratee):
        def wrapper(*args, **kwargs):
            for _ in range(stop_max_attempt_number-1):
                try:
                    return decoratee(*args, **kwargs)
                except Exception:
                    time.sleep(random.uniform(wait_random_min/1000, wait_random_max/1000))

            return decoratee(*args, **kwargs)

        return wrapper
    return decorator


class GoodsCreateYappyBeta(CreateYappyBeta):
    class Parameters(CreateYappyBeta.Parameters):
        juggler_url = sdk2.parameters.String('Juggler url', required=True)
        juggler_source = sdk2.parameters.String('Juggler source', required=True)
        juggler_host = sdk2.parameters.String('Juggler host', required=True)
        juggler_service = sdk2.parameters.String('Juggler service', required=True)
        juggler_tags = sdk2.parameters.List('Juggler tags', required=False)

    @retry(stop_max_attempt_number=3, wait_random_min=1000, wait_random_max=3000)
    def _send_juggler_event(self, event):
        LOGGER.info('pushing event to Juggler: {}'.format(event))

        event_template = {
            'host': self.Parameters.juggler_host,
            'service': self.Parameters.juggler_service,
        }

        if self.Parameters.juggler_tags:
            event_template['tags'] = self.Parameters.juggler_tags

        complete_event = dict(event_template, **event)

        reply = requests.post(self.Parameters.juggler_url, json={
            'source': self.Parameters.juggler_source,
            'events': [complete_event]
        })

        events = reply.json()['events']
        errors = []
        for event in events:
            if event['code'] != 200:
                errors.append(event['error'])

        if len(errors) > 0:
            raise Exception('Failed to send events: ' + ' ; '.join(errors))

    def on_yappy_beta_status(self, status):
        status2event = {
            'CONSISTENT': {
                'status': 'OK',
                'description': 'Yappy beta created successfully'
            },
            'NOT_ENOUGH_SLOTS': {
                'status': 'CRIT',
                'description': 'Not enough slots to create yappy beta'
            }
        }

        event = status2event.get(status)
        if event:
            self._send_juggler_event(event)

    def on_execute(self):
        try:
            super(GoodsCreateYappyBeta, self).on_execute()
        except YappyBetaCreationTimeoutError:
            self._send_juggler_event({
                'status': 'CRIT',
                'description': 'Yappy beta creation timed out'
            })

            six.reraise(*sys.exc_info())
