from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.common.nanny import nanny
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.goods.resources import GoodsMetaConfigBundle, GoodsBaseConfigBundle

import logging


class MakeGoodsConfigs(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Context(sdk2.Context):
        errors_on_download = 0

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 2048
        disk_space = 2048

    class Parameters(sdk2.task.Parameters):
        arcadia_path = sdk2.parameters.ArcadiaUrl(
            'Base arcadia url', required=True, default_value=Arcadia.trunk_url() + '/extsearch/goods/report/static_configs'
        )
        upload_base_configs = sdk2.parameters.Bool("Upload base configs", default=False)
        upload_meta_configs = sdk2.parameters.Bool("Upload meta configs", default=False)

    def make_resource(self, arcadia_path, resource_type, suffix_dir):
        local_configs_path = str(sdk2.svn.Arcadia.get_arcadia_src_dir(arcadia_path))
        resource = resource_type(self, self.Parameters.description, suffix_dir)
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir(0o755, parents=True, exist_ok=True)
        local_resource_path = str(resource_data.path)

        logging.info('Copying resource contents from {} into {}'.format(local_configs_path, local_resource_path))
        subprocess.check_call('cp -rf {}/{}/* {}'.format(local_configs_path, suffix_dir, local_resource_path), shell=True)
        resource_data.ready()

    def on_execute(self):
        if self.Parameters.upload_base_configs:
            self.make_resource(self.Parameters.arcadia_path, GoodsBaseConfigBundle, "base")

        if self.Parameters.upload_meta_configs:
            self.make_resource(self.Parameters.arcadia_path, GoodsMetaConfigBundle, "meta")

    def on_release(self, params):
        super(MakeGoodsConfigs, self).on_release(params)
        self.mark_released_resources(params["release_status"], ttl=30)
